// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    public partial class CommitmentPlanProperties : IUtf8JsonSerializable, IJsonModel<CommitmentPlanProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CommitmentPlanProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CommitmentPlanProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommitmentPlanProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CommitmentPlanProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(CommitmentPlanGuid))
            {
                writer.WritePropertyName("commitmentPlanGuid"u8);
                writer.WriteStringValue(CommitmentPlanGuid.Value);
            }
            if (Optional.IsDefined(HostingModel))
            {
                writer.WritePropertyName("hostingModel"u8);
                writer.WriteStringValue(HostingModel.Value.ToString());
            }
            if (Optional.IsDefined(PlanType))
            {
                writer.WritePropertyName("planType"u8);
                writer.WriteStringValue(PlanType);
            }
            if (Optional.IsDefined(Current))
            {
                writer.WritePropertyName("current"u8);
                writer.WriteObjectValue(Current, options);
            }
            if (Optional.IsDefined(AutoRenew))
            {
                writer.WritePropertyName("autoRenew"u8);
                writer.WriteBooleanValue(AutoRenew.Value);
            }
            if (Optional.IsDefined(Next))
            {
                writer.WritePropertyName("next"u8);
                writer.WriteObjectValue(Next, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Last))
            {
                writer.WritePropertyName("last"u8);
                writer.WriteObjectValue(Last, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ProvisioningIssues))
            {
                writer.WritePropertyName("provisioningIssues"u8);
                writer.WriteStartArray();
                foreach (var item in ProvisioningIssues)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CommitmentPlanProperties IJsonModel<CommitmentPlanProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommitmentPlanProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CommitmentPlanProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCommitmentPlanProperties(document.RootElement, options);
        }

        internal static CommitmentPlanProperties DeserializeCommitmentPlanProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CommitmentPlanProvisioningState? provisioningState = default;
            Guid? commitmentPlanGuid = default;
            ServiceAccountHostingModel? hostingModel = default;
            string planType = default;
            CommitmentPeriod current = default;
            bool? autoRenew = default;
            CommitmentPeriod next = default;
            CommitmentPeriod last = default;
            IReadOnlyList<string> provisioningIssues = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new CommitmentPlanProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("commitmentPlanGuid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    commitmentPlanGuid = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("hostingModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hostingModel = new ServiceAccountHostingModel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("planType"u8))
                {
                    planType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("current"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    current = CommitmentPeriod.DeserializeCommitmentPeriod(property.Value, options);
                    continue;
                }
                if (property.NameEquals("autoRenew"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoRenew = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("next"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    next = CommitmentPeriod.DeserializeCommitmentPeriod(property.Value, options);
                    continue;
                }
                if (property.NameEquals("last"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    last = CommitmentPeriod.DeserializeCommitmentPeriod(property.Value, options);
                    continue;
                }
                if (property.NameEquals("provisioningIssues"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    provisioningIssues = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CommitmentPlanProperties(
                provisioningState,
                commitmentPlanGuid,
                hostingModel,
                planType,
                current,
                autoRenew,
                next,
                last,
                provisioningIssues ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CommitmentPlanGuid), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  commitmentPlanGuid: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CommitmentPlanGuid))
                {
                    builder.Append("  commitmentPlanGuid: ");
                    builder.AppendLine($"'{CommitmentPlanGuid.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HostingModel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hostingModel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HostingModel))
                {
                    builder.Append("  hostingModel: ");
                    builder.AppendLine($"'{HostingModel.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PlanType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  planType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PlanType))
                {
                    builder.Append("  planType: ");
                    if (PlanType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PlanType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PlanType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Current), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  current: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Current))
                {
                    builder.Append("  current: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Current, options, 2, false, "  current: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoRenew), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  autoRenew: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoRenew))
                {
                    builder.Append("  autoRenew: ");
                    var boolValue = AutoRenew.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Next), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  next: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Next))
                {
                    builder.Append("  next: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Next, options, 2, false, "  next: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Last), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  last: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Last))
                {
                    builder.Append("  last: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Last, options, 2, false, "  last: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningIssues), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningIssues: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ProvisioningIssues))
                {
                    if (ProvisioningIssues.Any())
                    {
                        builder.Append("  provisioningIssues: ");
                        builder.AppendLine("[");
                        foreach (var item in ProvisioningIssues)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CommitmentPlanProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommitmentPlanProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CommitmentPlanProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CommitmentPlanProperties IPersistableModel<CommitmentPlanProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CommitmentPlanProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCommitmentPlanProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CommitmentPlanProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CommitmentPlanProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
