// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT. </summary>
    public readonly partial struct CognitiveServicesSkuTier : IEquatable<CognitiveServicesSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CognitiveServicesSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FreeValue = "Free";
        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string EnterpriseValue = "Enterprise";

        /// <summary> Free. </summary>
        public static CognitiveServicesSkuTier Free { get; } = new CognitiveServicesSkuTier(FreeValue);
        /// <summary> Basic. </summary>
        public static CognitiveServicesSkuTier Basic { get; } = new CognitiveServicesSkuTier(BasicValue);
        /// <summary> Standard. </summary>
        public static CognitiveServicesSkuTier Standard { get; } = new CognitiveServicesSkuTier(StandardValue);
        /// <summary> Premium. </summary>
        public static CognitiveServicesSkuTier Premium { get; } = new CognitiveServicesSkuTier(PremiumValue);
        /// <summary> Enterprise. </summary>
        public static CognitiveServicesSkuTier Enterprise { get; } = new CognitiveServicesSkuTier(EnterpriseValue);
        /// <summary> Determines if two <see cref="CognitiveServicesSkuTier"/> values are the same. </summary>
        public static bool operator ==(CognitiveServicesSkuTier left, CognitiveServicesSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CognitiveServicesSkuTier"/> values are not the same. </summary>
        public static bool operator !=(CognitiveServicesSkuTier left, CognitiveServicesSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CognitiveServicesSkuTier"/>. </summary>
        public static implicit operator CognitiveServicesSkuTier(string value) => new CognitiveServicesSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CognitiveServicesSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CognitiveServicesSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
