// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> The reason for restriction. </summary>
    public readonly partial struct CognitiveServicesSkuRestrictionReasonCode : IEquatable<CognitiveServicesSkuRestrictionReasonCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesSkuRestrictionReasonCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CognitiveServicesSkuRestrictionReasonCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QuotaIdValue = "QuotaId";
        private const string NotAvailableForSubscriptionValue = "NotAvailableForSubscription";

        /// <summary> QuotaId. </summary>
        public static CognitiveServicesSkuRestrictionReasonCode QuotaId { get; } = new CognitiveServicesSkuRestrictionReasonCode(QuotaIdValue);
        /// <summary> NotAvailableForSubscription. </summary>
        public static CognitiveServicesSkuRestrictionReasonCode NotAvailableForSubscription { get; } = new CognitiveServicesSkuRestrictionReasonCode(NotAvailableForSubscriptionValue);
        /// <summary> Determines if two <see cref="CognitiveServicesSkuRestrictionReasonCode"/> values are the same. </summary>
        public static bool operator ==(CognitiveServicesSkuRestrictionReasonCode left, CognitiveServicesSkuRestrictionReasonCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CognitiveServicesSkuRestrictionReasonCode"/> values are not the same. </summary>
        public static bool operator !=(CognitiveServicesSkuRestrictionReasonCode left, CognitiveServicesSkuRestrictionReasonCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CognitiveServicesSkuRestrictionReasonCode"/>. </summary>
        public static implicit operator CognitiveServicesSkuRestrictionReasonCode(string value) => new CognitiveServicesSkuRestrictionReasonCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CognitiveServicesSkuRestrictionReasonCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CognitiveServicesSkuRestrictionReasonCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
