// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Multiregion routing methods. </summary>
    public readonly partial struct CognitiveServicesRoutingMethod : IEquatable<CognitiveServicesRoutingMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesRoutingMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CognitiveServicesRoutingMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PriorityValue = "Priority";
        private const string WeightedValue = "Weighted";
        private const string PerformanceValue = "Performance";

        /// <summary> Priority. </summary>
        public static CognitiveServicesRoutingMethod Priority { get; } = new CognitiveServicesRoutingMethod(PriorityValue);
        /// <summary> Weighted. </summary>
        public static CognitiveServicesRoutingMethod Weighted { get; } = new CognitiveServicesRoutingMethod(WeightedValue);
        /// <summary> Performance. </summary>
        public static CognitiveServicesRoutingMethod Performance { get; } = new CognitiveServicesRoutingMethod(PerformanceValue);
        /// <summary> Determines if two <see cref="CognitiveServicesRoutingMethod"/> values are the same. </summary>
        public static bool operator ==(CognitiveServicesRoutingMethod left, CognitiveServicesRoutingMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CognitiveServicesRoutingMethod"/> values are not the same. </summary>
        public static bool operator !=(CognitiveServicesRoutingMethod left, CognitiveServicesRoutingMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CognitiveServicesRoutingMethod"/>. </summary>
        public static implicit operator CognitiveServicesRoutingMethod(string value) => new CognitiveServicesRoutingMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CognitiveServicesRoutingMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CognitiveServicesRoutingMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
