// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct CognitiveServicesPrivateEndpointConnectionProvisioningState : IEquatable<CognitiveServicesPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CognitiveServicesPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static CognitiveServicesPrivateEndpointConnectionProvisioningState Succeeded { get; } = new CognitiveServicesPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static CognitiveServicesPrivateEndpointConnectionProvisioningState Creating { get; } = new CognitiveServicesPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static CognitiveServicesPrivateEndpointConnectionProvisioningState Deleting { get; } = new CognitiveServicesPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static CognitiveServicesPrivateEndpointConnectionProvisioningState Failed { get; } = new CognitiveServicesPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="CognitiveServicesPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CognitiveServicesPrivateEndpointConnectionProvisioningState left, CognitiveServicesPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CognitiveServicesPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CognitiveServicesPrivateEndpointConnectionProvisioningState left, CognitiveServicesPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CognitiveServicesPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator CognitiveServicesPrivateEndpointConnectionProvisioningState(string value) => new CognitiveServicesPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CognitiveServicesPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CognitiveServicesPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
