// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated. </summary>
    public readonly partial struct CognitiveServicesNetworkRuleAction : IEquatable<CognitiveServicesNetworkRuleAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesNetworkRuleAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CognitiveServicesNetworkRuleAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static CognitiveServicesNetworkRuleAction Allow { get; } = new CognitiveServicesNetworkRuleAction(AllowValue);
        /// <summary> Deny. </summary>
        public static CognitiveServicesNetworkRuleAction Deny { get; } = new CognitiveServicesNetworkRuleAction(DenyValue);
        /// <summary> Determines if two <see cref="CognitiveServicesNetworkRuleAction"/> values are the same. </summary>
        public static bool operator ==(CognitiveServicesNetworkRuleAction left, CognitiveServicesNetworkRuleAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CognitiveServicesNetworkRuleAction"/> values are not the same. </summary>
        public static bool operator !=(CognitiveServicesNetworkRuleAction left, CognitiveServicesNetworkRuleAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CognitiveServicesNetworkRuleAction"/>. </summary>
        public static implicit operator CognitiveServicesNetworkRuleAction(string value) => new CognitiveServicesNetworkRuleAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CognitiveServicesNetworkRuleAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CognitiveServicesNetworkRuleAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
