// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Properties to configure keyVault Properties. </summary>
    public partial class CognitiveServicesKeyVaultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesKeyVaultProperties"/>. </summary>
        public CognitiveServicesKeyVaultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesKeyVaultProperties"/>. </summary>
        /// <param name="keyName"> Name of the Key from KeyVault. </param>
        /// <param name="keyVersion"> Version of the Key from KeyVault. </param>
        /// <param name="keyVaultUri"> Uri of KeyVault. </param>
        /// <param name="identityClientId"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CognitiveServicesKeyVaultProperties(string keyName, string keyVersion, Uri keyVaultUri, Guid? identityClientId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            KeyVersion = keyVersion;
            KeyVaultUri = keyVaultUri;
            IdentityClientId = identityClientId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the Key from KeyVault. </summary>
        [WirePath("keyName")]
        public string KeyName { get; set; }
        /// <summary> Version of the Key from KeyVault. </summary>
        [WirePath("keyVersion")]
        public string KeyVersion { get; set; }
        /// <summary> Uri of KeyVault. </summary>
        [WirePath("keyVaultUri")]
        public Uri KeyVaultUri { get; set; }
        /// <summary> Gets or sets the identity client id. </summary>
        [WirePath("identityClientId")]
        public Guid? IdentityClientId { get; set; }
    }
}
