// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> The capacity configuration. </summary>
    public partial class CognitiveServicesCapacityConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesCapacityConfig"/>. </summary>
        public CognitiveServicesCapacityConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesCapacityConfig"/>. </summary>
        /// <param name="minimum"> The minimum capacity. </param>
        /// <param name="maximum"> The maximum capacity. </param>
        /// <param name="step"> The minimal incremental between allowed values for capacity. </param>
        /// <param name="default"> The default capacity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CognitiveServicesCapacityConfig(int? minimum, int? maximum, int? step, int? @default, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Minimum = minimum;
            Maximum = maximum;
            Step = step;
            Default = @default;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The minimum capacity. </summary>
        [WirePath("minimum")]
        public int? Minimum { get; set; }
        /// <summary> The maximum capacity. </summary>
        [WirePath("maximum")]
        public int? Maximum { get; set; }
        /// <summary> The minimal incremental between allowed values for capacity. </summary>
        [WirePath("step")]
        public int? Step { get; set; }
        /// <summary> The default capacity. </summary>
        [WirePath("default")]
        public int? Default { get; set; }
    }
}
