// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Properties of Cognitive Services account deployment model. </summary>
    public partial class CognitiveServicesAccountDeploymentScaleSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesAccountDeploymentScaleSettings"/>. </summary>
        public CognitiveServicesAccountDeploymentScaleSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServicesAccountDeploymentScaleSettings"/>. </summary>
        /// <param name="scaleType"> Deployment scale type. </param>
        /// <param name="capacity"> Deployment capacity. </param>
        /// <param name="activeCapacity"> Deployment active capacity. This value might be different from `capacity` if customer recently updated `capacity`. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CognitiveServicesAccountDeploymentScaleSettings(CognitiveServicesAccountDeploymentScaleType? scaleType, int? capacity, int? activeCapacity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ScaleType = scaleType;
            Capacity = capacity;
            ActiveCapacity = activeCapacity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Deployment scale type. </summary>
        [WirePath("scaleType")]
        public CognitiveServicesAccountDeploymentScaleType? ScaleType { get; set; }
        /// <summary> Deployment capacity. </summary>
        [WirePath("capacity")]
        public int? Capacity { get; set; }
        /// <summary> Deployment active capacity. This value might be different from `capacity` if customer recently updated `capacity`. </summary>
        [WirePath("activeCapacity")]
        public int? ActiveCapacity { get; }
    }
}
