// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> The action of AbusePenalty. </summary>
    public readonly partial struct AbusePenaltyAction : IEquatable<AbusePenaltyAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AbusePenaltyAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AbusePenaltyAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ThrottleValue = "Throttle";
        private const string BlockValue = "Block";

        /// <summary> Throttle. </summary>
        public static AbusePenaltyAction Throttle { get; } = new AbusePenaltyAction(ThrottleValue);
        /// <summary> Block. </summary>
        public static AbusePenaltyAction Block { get; } = new AbusePenaltyAction(BlockValue);
        /// <summary> Determines if two <see cref="AbusePenaltyAction"/> values are the same. </summary>
        public static bool operator ==(AbusePenaltyAction left, AbusePenaltyAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AbusePenaltyAction"/> values are not the same. </summary>
        public static bool operator !=(AbusePenaltyAction left, AbusePenaltyAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AbusePenaltyAction"/>. </summary>
        public static implicit operator AbusePenaltyAction(string value) => new AbusePenaltyAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AbusePenaltyAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AbusePenaltyAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
