// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CognitiveServices
{
    internal class CommitmentPlanAccountAssociationOperationSource : IOperationSource<CommitmentPlanAccountAssociationResource>
    {
        private readonly ArmClient _client;

        internal CommitmentPlanAccountAssociationOperationSource(ArmClient client)
        {
            _client = client;
        }

        CommitmentPlanAccountAssociationResource IOperationSource<CommitmentPlanAccountAssociationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CommitmentPlanAccountAssociationData.DeserializeCommitmentPlanAccountAssociationData(document.RootElement);
            return new CommitmentPlanAccountAssociationResource(_client, data);
        }

        async ValueTask<CommitmentPlanAccountAssociationResource> IOperationSource<CommitmentPlanAccountAssociationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CommitmentPlanAccountAssociationData.DeserializeCommitmentPlanAccountAssociationData(document.RootElement);
            return new CommitmentPlanAccountAssociationResource(_client, data);
        }
    }
}
