// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.CognitiveServices
{
    internal class CognitiveServicesAccountOperationSource : IOperationSource<CognitiveServicesAccountResource>
    {
        private readonly ArmClient _client;

        internal CognitiveServicesAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        CognitiveServicesAccountResource IOperationSource<CognitiveServicesAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CognitiveServicesAccountData.DeserializeCognitiveServicesAccountData(document.RootElement);
            return new CognitiveServicesAccountResource(_client, data);
        }

        async ValueTask<CognitiveServicesAccountResource> IOperationSource<CognitiveServicesAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CognitiveServicesAccountData.DeserializeCognitiveServicesAccountData(document.RootElement);
            return new CognitiveServicesAccountResource(_client, data);
        }
    }
}
