// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.CognitiveServices.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmCognitiveServicesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="CognitiveServices.CognitiveServicesAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> The Kind of the resource. </param>
        /// <param name="sku"> The resource model definition representing SKU. </param>
        /// <param name="identity"> Identity for the resource. </param>
        /// <param name="properties"> Properties of Cognitive Services account. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="CognitiveServices.CognitiveServicesAccountData"/> instance for mocking. </returns>
        public static CognitiveServicesAccountData CognitiveServicesAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string kind = null, CognitiveServicesSku sku = null, ManagedServiceIdentity identity = null, CognitiveServicesAccountProperties properties = null, ETag? etag = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CognitiveServicesAccountData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                sku,
                identity,
                properties,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesAccountProperties"/>. </summary>
        /// <param name="provisioningState"> Gets the status of the cognitive services account at the time the operation was called. </param>
        /// <param name="endpoint"> Endpoint of the created account. </param>
        /// <param name="capabilities"> Gets the capabilities of the cognitive services account. Each item indicates the capability of a specific feature. The values are read-only and for reference only. </param>
        /// <param name="isMigrated"> If the resource is migrated from an existing key. </param>
        /// <param name="migrationToken"> Resource migration token. </param>
        /// <param name="skuChangeInfo"> Sku change info of account. </param>
        /// <param name="customSubDomainName"> Optional subdomain name used for token-based authentication. </param>
        /// <param name="networkAcls"> A collection of rules governing the accessibility from specific network locations. </param>
        /// <param name="encryption"> The encryption properties for this resource. </param>
        /// <param name="userOwnedStorage"> The storage accounts for this resource. </param>
        /// <param name="privateEndpointConnections"> The private endpoint connection associated with the Cognitive Services account. </param>
        /// <param name="publicNetworkAccess"> Whether or not public endpoint access is allowed for this account. </param>
        /// <param name="apiProperties"> The api properties for special APIs. </param>
        /// <param name="createdOn"> Gets the date of cognitive services account creation. </param>
        /// <param name="callRateLimit"> The call rate limit Cognitive Services account. </param>
        /// <param name="enableDynamicThrottling"> The flag to enable dynamic throttling. </param>
        /// <param name="quotaLimit"></param>
        /// <param name="restrictOutboundNetworkAccess"></param>
        /// <param name="allowedFqdnList"></param>
        /// <param name="disableLocalAuth"></param>
        /// <param name="endpoints"> Dictionary of &lt;string&gt;. </param>
        /// <param name="restore"></param>
        /// <param name="deletedOn"> The deletion date, only available for deleted account. </param>
        /// <param name="scheduledPurgeDate"> The scheduled purge date, only available for deleted account. </param>
        /// <param name="locations"> The multiregion settings of Cognitive Services account. </param>
        /// <param name="commitmentPlanAssociations"> The commitment plan associations of Cognitive Services account. </param>
        /// <param name="abusePenalty"> The abuse penalty. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesAccountProperties"/> instance for mocking. </returns>
        public static CognitiveServicesAccountProperties CognitiveServicesAccountProperties(ServiceAccountProvisioningState? provisioningState = null, string endpoint = null, IEnumerable<CognitiveServicesSkuCapability> capabilities = null, bool? isMigrated = null, string migrationToken = null, CognitiveServicesSkuChangeInfo skuChangeInfo = null, string customSubDomainName = null, CognitiveServicesNetworkRuleSet networkAcls = null, ServiceAccountEncryptionProperties encryption = null, IEnumerable<ServiceAccountUserOwnedStorage> userOwnedStorage = null, IEnumerable<CognitiveServicesPrivateEndpointConnectionData> privateEndpointConnections = null, ServiceAccountPublicNetworkAccess? publicNetworkAccess = null, ServiceAccountApiProperties apiProperties = null, DateTimeOffset? createdOn = null, ServiceAccountCallRateLimit callRateLimit = null, bool? enableDynamicThrottling = null, ServiceAccountQuotaLimit quotaLimit = null, bool? restrictOutboundNetworkAccess = null, IEnumerable<string> allowedFqdnList = null, bool? disableLocalAuth = null, IReadOnlyDictionary<string, string> endpoints = null, bool? restore = null, DateTimeOffset? deletedOn = null, string scheduledPurgeDate = null, CognitiveServicesMultiRegionSettings locations = null, IEnumerable<CommitmentPlanAssociation> commitmentPlanAssociations = null, AbusePenalty abusePenalty = null)
        {
            capabilities ??= new List<CognitiveServicesSkuCapability>();
            userOwnedStorage ??= new List<ServiceAccountUserOwnedStorage>();
            privateEndpointConnections ??= new List<CognitiveServicesPrivateEndpointConnectionData>();
            allowedFqdnList ??= new List<string>();
            endpoints ??= new Dictionary<string, string>();
            commitmentPlanAssociations ??= new List<CommitmentPlanAssociation>();

            return new CognitiveServicesAccountProperties(
                provisioningState,
                endpoint,
                capabilities?.ToList(),
                isMigrated,
                migrationToken,
                skuChangeInfo,
                customSubDomainName,
                networkAcls,
                encryption,
                userOwnedStorage?.ToList(),
                privateEndpointConnections?.ToList(),
                publicNetworkAccess,
                apiProperties,
                createdOn,
                callRateLimit,
                enableDynamicThrottling,
                quotaLimit,
                restrictOutboundNetworkAccess,
                allowedFqdnList?.ToList(),
                disableLocalAuth,
                endpoints,
                restore,
                deletedOn,
                scheduledPurgeDate,
                locations,
                commitmentPlanAssociations?.ToList(),
                abusePenalty,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesSkuCapability"/>. </summary>
        /// <param name="name"> The name of the SkuCapability. </param>
        /// <param name="value"> The value of the SkuCapability. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesSkuCapability"/> instance for mocking. </returns>
        public static CognitiveServicesSkuCapability CognitiveServicesSkuCapability(string name = null, string value = null)
        {
            return new CognitiveServicesSkuCapability(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesSkuChangeInfo"/>. </summary>
        /// <param name="countOfDowngrades"> Gets the count of downgrades. </param>
        /// <param name="countOfUpgradesAfterDowngrades"> Gets the count of upgrades after downgrades. </param>
        /// <param name="lastChangedOn"> Gets the last change date. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesSkuChangeInfo"/> instance for mocking. </returns>
        public static CognitiveServicesSkuChangeInfo CognitiveServicesSkuChangeInfo(float? countOfDowngrades = null, float? countOfUpgradesAfterDowngrades = null, DateTimeOffset? lastChangedOn = null)
        {
            return new CognitiveServicesSkuChangeInfo(countOfDowngrades, countOfUpgradesAfterDowngrades, lastChangedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServices.CognitiveServicesPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> The location of the private endpoint connection. </param>
        /// <param name="privateEndpointId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <param name="groupIds"> The private link resource group ids. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="CognitiveServices.CognitiveServicesPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static CognitiveServicesPrivateEndpointConnectionData CognitiveServicesPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, ResourceIdentifier privateEndpointId = null, CognitiveServicesPrivateLinkServiceConnectionState connectionState = null, CognitiveServicesPrivateEndpointConnectionProvisioningState? provisioningState = null, IEnumerable<string> groupIds = null, ETag? etag = null)
        {
            groupIds ??= new List<string>();

            return new CognitiveServicesPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                location,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                groupIds?.ToList(),
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountCallRateLimit"/>. </summary>
        /// <param name="count"> The count value of Call Rate Limit. </param>
        /// <param name="renewalPeriod"> The renewal period in seconds of Call Rate Limit. </param>
        /// <param name="rules"></param>
        /// <returns> A new <see cref="Models.ServiceAccountCallRateLimit"/> instance for mocking. </returns>
        public static ServiceAccountCallRateLimit ServiceAccountCallRateLimit(float? count = null, float? renewalPeriod = null, IEnumerable<ServiceAccountThrottlingRule> rules = null)
        {
            rules ??= new List<ServiceAccountThrottlingRule>();

            return new ServiceAccountCallRateLimit(count, renewalPeriod, rules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountThrottlingRule"/>. </summary>
        /// <param name="key"></param>
        /// <param name="renewalPeriod"></param>
        /// <param name="count"></param>
        /// <param name="minCount"></param>
        /// <param name="isDynamicThrottlingEnabled"></param>
        /// <param name="matchPatterns"></param>
        /// <returns> A new <see cref="Models.ServiceAccountThrottlingRule"/> instance for mocking. </returns>
        public static ServiceAccountThrottlingRule ServiceAccountThrottlingRule(string key = null, float? renewalPeriod = null, float? count = null, float? minCount = null, bool? isDynamicThrottlingEnabled = null, IEnumerable<ServiceAccountThrottlingMatchPattern> matchPatterns = null)
        {
            matchPatterns ??= new List<ServiceAccountThrottlingMatchPattern>();

            return new ServiceAccountThrottlingRule(
                key,
                renewalPeriod,
                count,
                minCount,
                isDynamicThrottlingEnabled,
                matchPatterns?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountThrottlingMatchPattern"/>. </summary>
        /// <param name="path"></param>
        /// <param name="method"></param>
        /// <returns> A new <see cref="Models.ServiceAccountThrottlingMatchPattern"/> instance for mocking. </returns>
        public static ServiceAccountThrottlingMatchPattern ServiceAccountThrottlingMatchPattern(string path = null, string method = null)
        {
            return new ServiceAccountThrottlingMatchPattern(path, method, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountQuotaLimit"/>. </summary>
        /// <param name="count"></param>
        /// <param name="renewalPeriod"></param>
        /// <param name="rules"></param>
        /// <returns> A new <see cref="Models.ServiceAccountQuotaLimit"/> instance for mocking. </returns>
        public static ServiceAccountQuotaLimit ServiceAccountQuotaLimit(float? count = null, float? renewalPeriod = null, IEnumerable<ServiceAccountThrottlingRule> rules = null)
        {
            rules ??= new List<ServiceAccountThrottlingRule>();

            return new ServiceAccountQuotaLimit(count, renewalPeriod, rules?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommitmentPlanAssociation"/>. </summary>
        /// <param name="commitmentPlanId"> The Azure resource id of the commitment plan. </param>
        /// <param name="commitmentPlanLocation"> The location of of the commitment plan. </param>
        /// <returns> A new <see cref="Models.CommitmentPlanAssociation"/> instance for mocking. </returns>
        public static CommitmentPlanAssociation CommitmentPlanAssociation(ResourceIdentifier commitmentPlanId = null, string commitmentPlanLocation = null)
        {
            return new CommitmentPlanAssociation(commitmentPlanId, commitmentPlanLocation, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AbusePenalty"/>. </summary>
        /// <param name="action"> The action of AbusePenalty. </param>
        /// <param name="rateLimitPercentage"> The percentage of rate limit. </param>
        /// <param name="expiration"> The datetime of expiration of the AbusePenalty. </param>
        /// <returns> A new <see cref="Models.AbusePenalty"/> instance for mocking. </returns>
        public static AbusePenalty AbusePenalty(AbusePenaltyAction? action = null, float? rateLimitPercentage = null, DateTimeOffset? expiration = null)
        {
            return new AbusePenalty(action, rateLimitPercentage, expiration, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountApiKeys"/>. </summary>
        /// <param name="key1"> Gets the value of key 1. </param>
        /// <param name="key2"> Gets the value of key 2. </param>
        /// <returns> A new <see cref="Models.ServiceAccountApiKeys"/> instance for mocking. </returns>
        public static ServiceAccountApiKeys ServiceAccountApiKeys(string key1 = null, string key2 = null)
        {
            return new ServiceAccountApiKeys(key1, key2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableCognitiveServicesSku"/>. </summary>
        /// <param name="resourceType"> The type of resource the SKU applies to. </param>
        /// <param name="name"> The name of SKU. </param>
        /// <param name="tier"> Specifies the tier of Cognitive Services account. </param>
        /// <param name="kind"> The Kind of resources that are supported in this SKU. </param>
        /// <param name="locations"> The set of locations that the SKU is available. </param>
        /// <param name="restrictions"> The restrictions because of which SKU cannot be used. This is empty if there are no restrictions. </param>
        /// <returns> A new <see cref="Models.AvailableCognitiveServicesSku"/> instance for mocking. </returns>
        public static AvailableCognitiveServicesSku AvailableCognitiveServicesSku(string resourceType = null, string name = null, string tier = null, string kind = null, IEnumerable<AzureLocation> locations = null, IEnumerable<CognitiveServicesSkuRestrictions> restrictions = null)
        {
            locations ??= new List<AzureLocation>();
            restrictions ??= new List<CognitiveServicesSkuRestrictions>();

            return new AvailableCognitiveServicesSku(
                resourceType,
                name,
                tier,
                kind,
                locations?.ToList(),
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesSkuRestrictions"/>. </summary>
        /// <param name="restrictionsType"> The type of restrictions. </param>
        /// <param name="values"> The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted. </param>
        /// <param name="restrictionInfo"> The information about the restriction where the SKU cannot be used. </param>
        /// <param name="reasonCode"> The reason for restriction. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesSkuRestrictions"/> instance for mocking. </returns>
        public static CognitiveServicesSkuRestrictions CognitiveServicesSkuRestrictions(CognitiveServicesSkuRestrictionsType? restrictionsType = null, IEnumerable<string> values = null, CognitiveServicesSkuRestrictionInfo restrictionInfo = null, CognitiveServicesSkuRestrictionReasonCode? reasonCode = null)
        {
            values ??= new List<string>();

            return new CognitiveServicesSkuRestrictions(restrictionsType, values?.ToList(), restrictionInfo, reasonCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesSkuRestrictionInfo"/>. </summary>
        /// <param name="locations"> Locations where the SKU is restricted. </param>
        /// <param name="zones"> List of availability zones where the SKU is restricted. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesSkuRestrictionInfo"/> instance for mocking. </returns>
        public static CognitiveServicesSkuRestrictionInfo CognitiveServicesSkuRestrictionInfo(IEnumerable<AzureLocation> locations = null, IEnumerable<string> zones = null)
        {
            locations ??= new List<AzureLocation>();
            zones ??= new List<string>();

            return new CognitiveServicesSkuRestrictionInfo(locations?.ToList(), zones?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesAccountSku"/>. </summary>
        /// <param name="resourceType"> Resource Namespace and Type. </param>
        /// <param name="sku"> The SKU of Cognitive Services account. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesAccountSku"/> instance for mocking. </returns>
        public static CognitiveServicesAccountSku CognitiveServicesAccountSku(ResourceType? resourceType = null, CognitiveServicesSku sku = null)
        {
            return new CognitiveServicesAccountSku(resourceType, sku, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountUsage"/>. </summary>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="name"> The name information for the metric. </param>
        /// <param name="quotaPeriod"> The quota period used to summarize the usage values. </param>
        /// <param name="limit"> Maximum value for this metric. </param>
        /// <param name="currentValue"> Current value for this metric. </param>
        /// <param name="nextResetTime"> Next reset time for current quota. </param>
        /// <param name="status"> Cognitive Services account quota usage status. </param>
        /// <returns> A new <see cref="Models.ServiceAccountUsage"/> instance for mocking. </returns>
        public static ServiceAccountUsage ServiceAccountUsage(ServiceAccountUsageUnitType? unit = null, ServiceAccountUsageMetricName name = null, string quotaPeriod = null, double? limit = null, double? currentValue = null, string nextResetTime = null, ServiceAccountQuotaUsageStatus? status = null)
        {
            return new ServiceAccountUsage(
                unit,
                name,
                quotaPeriod,
                limit,
                currentValue,
                nextResetTime,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServiceAccountUsageMetricName"/>. </summary>
        /// <param name="value"> The name of the metric. </param>
        /// <param name="localizedValue"> The friendly name of the metric. </param>
        /// <returns> A new <see cref="Models.ServiceAccountUsageMetricName"/> instance for mocking. </returns>
        public static ServiceAccountUsageMetricName ServiceAccountUsageMetricName(string value = null, string localizedValue = null)
        {
            return new ServiceAccountUsageMetricName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesAccountModel"/>. </summary>
        /// <param name="format"> Deployment model format. </param>
        /// <param name="name"> Deployment model name. </param>
        /// <param name="version"> Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API. </param>
        /// <param name="source"> Optional. Deployment model source ARM resource ID. </param>
        /// <param name="callRateLimit"> The call rate limit Cognitive Services account. </param>
        /// <param name="baseModel"> Base Model Identifier. </param>
        /// <param name="isDefaultVersion"> If the model is default version. </param>
        /// <param name="skus"> The list of Model Sku. </param>
        /// <param name="maxCapacity"> The max capacity. </param>
        /// <param name="capabilities"> The capabilities. </param>
        /// <param name="finetuneCapabilities"> The capabilities for finetune models. </param>
        /// <param name="deprecation"> Cognitive Services account ModelDeprecationInfo. </param>
        /// <param name="lifecycleStatus"> Model lifecycle status. </param>
        /// <param name="systemData"> Metadata pertaining to creation and last modification of the resource. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesAccountModel"/> instance for mocking. </returns>
        public static CognitiveServicesAccountModel CognitiveServicesAccountModel(string format = null, string name = null, string version = null, string source = null, ServiceAccountCallRateLimit callRateLimit = null, CognitiveServicesAccountDeploymentModel baseModel = null, bool? isDefaultVersion = null, IEnumerable<CognitiveServicesModelSku> skus = null, int? maxCapacity = null, IDictionary<string, string> capabilities = null, IDictionary<string, string> finetuneCapabilities = null, ServiceAccountModelDeprecationInfo deprecation = null, ModelLifecycleStatus? lifecycleStatus = null, SystemData systemData = null)
        {
            skus ??= new List<CognitiveServicesModelSku>();
            capabilities ??= new Dictionary<string, string>();
            finetuneCapabilities ??= new Dictionary<string, string>();

            return new CognitiveServicesAccountModel(
                format,
                name,
                version,
                source,
                callRateLimit,
                serializedAdditionalRawData: null,
                baseModel,
                isDefaultVersion,
                skus?.ToList(),
                maxCapacity,
                capabilities,
                finetuneCapabilities,
                deprecation,
                lifecycleStatus,
                systemData);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesAccountDeploymentModel"/>. </summary>
        /// <param name="format"> Deployment model format. </param>
        /// <param name="name"> Deployment model name. </param>
        /// <param name="version"> Optional. Deployment model version. If version is not specified, a default version will be assigned. The default version is different for different models and might change when there is new version available for a model. Default version for a model could be found from list models API. </param>
        /// <param name="source"> Optional. Deployment model source ARM resource ID. </param>
        /// <param name="callRateLimit"> The call rate limit Cognitive Services account. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesAccountDeploymentModel"/> instance for mocking. </returns>
        public static CognitiveServicesAccountDeploymentModel CognitiveServicesAccountDeploymentModel(string format = null, string name = null, string version = null, string source = null, ServiceAccountCallRateLimit callRateLimit = null)
        {
            return new CognitiveServicesAccountDeploymentModel(
                format,
                name,
                version,
                source,
                callRateLimit,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesModelSku"/>. </summary>
        /// <param name="name"> The name of the model SKU. </param>
        /// <param name="usageName"> The usage name of the model SKU. </param>
        /// <param name="deprecationOn"> The datetime of deprecation of the model SKU. </param>
        /// <param name="capacity"> The capacity configuration. </param>
        /// <param name="rateLimits"> The list of rateLimit. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesModelSku"/> instance for mocking. </returns>
        public static CognitiveServicesModelSku CognitiveServicesModelSku(string name = null, string usageName = null, DateTimeOffset? deprecationOn = null, CognitiveServicesCapacityConfig capacity = null, IEnumerable<ServiceAccountCallRateLimit> rateLimits = null)
        {
            rateLimits ??= new List<ServiceAccountCallRateLimit>();

            return new CognitiveServicesModelSku(
                name,
                usageName,
                deprecationOn,
                capacity,
                rateLimits?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesSkuAvailabilityList"/>. </summary>
        /// <param name="kind"> The Kind of the resource. </param>
        /// <param name="skuAvailabilityType"> The Type of the resource. </param>
        /// <param name="skuName"> The SKU of Cognitive Services account. </param>
        /// <param name="isSkuAvailable"> Indicates the given SKU is available or not. </param>
        /// <param name="reason"> Reason why the SKU is not available. </param>
        /// <param name="message"> Additional error message. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesSkuAvailabilityList"/> instance for mocking. </returns>
        public static CognitiveServicesSkuAvailabilityList CognitiveServicesSkuAvailabilityList(string kind = null, string skuAvailabilityType = null, string skuName = null, bool? isSkuAvailable = null, string reason = null, string message = null)
        {
            return new CognitiveServicesSkuAvailabilityList(
                kind,
                skuAvailabilityType,
                skuName,
                isSkuAvailable,
                reason,
                message,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommitmentTier"/>. </summary>
        /// <param name="kind"> The Kind of the resource. </param>
        /// <param name="skuName"> The name of the SKU. Ex - P3. It is typically a letter+number code. </param>
        /// <param name="hostingModel"> Account hosting model. </param>
        /// <param name="planType"> Commitment plan type. </param>
        /// <param name="tier"> Commitment period commitment tier. </param>
        /// <param name="maxCount"> Commitment period commitment max count. </param>
        /// <param name="quota"> Cognitive Services account commitment quota. </param>
        /// <param name="cost"> Cognitive Services account commitment cost. </param>
        /// <returns> A new <see cref="Models.CommitmentTier"/> instance for mocking. </returns>
        public static CommitmentTier CommitmentTier(string kind = null, string skuName = null, ServiceAccountHostingModel? hostingModel = null, string planType = null, string tier = null, int? maxCount = null, CommitmentQuota quota = null, CommitmentCost cost = null)
        {
            return new CommitmentTier(
                kind,
                skuName,
                hostingModel,
                planType,
                tier,
                maxCount,
                quota,
                cost,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommitmentQuota"/>. </summary>
        /// <param name="quantity"> Commitment quota quantity. </param>
        /// <param name="unit"> Commitment quota unit. </param>
        /// <returns> A new <see cref="Models.CommitmentQuota"/> instance for mocking. </returns>
        public static CommitmentQuota CommitmentQuota(long? quantity = null, string unit = null)
        {
            return new CommitmentQuota(quantity, unit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommitmentCost"/>. </summary>
        /// <param name="commitmentMeterId"> Commitment meter Id. </param>
        /// <param name="overageMeterId"> Overage meter Id. </param>
        /// <returns> A new <see cref="Models.CommitmentCost"/> instance for mocking. </returns>
        public static CommitmentCost CommitmentCost(string commitmentMeterId = null, string overageMeterId = null)
        {
            return new CommitmentCost(commitmentMeterId, overageMeterId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesModel"/>. </summary>
        /// <param name="model"> Model Metadata. </param>
        /// <param name="kind"> The Kind of the Model. </param>
        /// <param name="skuName"> The SKU of the Model. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesModel"/> instance for mocking. </returns>
        public static CognitiveServicesModel CognitiveServicesModel(CognitiveServicesAccountModel model = null, string kind = null, string skuName = null)
        {
            return new CognitiveServicesModel(model, kind, skuName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesDomainAvailabilityContent"/>. </summary>
        /// <param name="subdomainName"> The subdomain name to use. </param>
        /// <param name="resourceType"> The Type of the resource. </param>
        /// <param name="kind"> The Kind of the resource. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesDomainAvailabilityContent"/> instance for mocking. </returns>
        public static CognitiveServicesDomainAvailabilityContent CognitiveServicesDomainAvailabilityContent(string subdomainName = null, ResourceType resourceType = default, string kind = null)
        {
            return new CognitiveServicesDomainAvailabilityContent(subdomainName, resourceType, kind, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesDomainAvailabilityList"/>. </summary>
        /// <param name="isSubdomainAvailable"> Indicates the given SKU is available or not. </param>
        /// <param name="reason"> Reason why the SKU is not available. </param>
        /// <param name="subdomainName"> The subdomain name to use. </param>
        /// <param name="domainAvailabilityType"> The Type of the resource. </param>
        /// <param name="kind"> The Kind of the resource. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesDomainAvailabilityList"/> instance for mocking. </returns>
        public static CognitiveServicesDomainAvailabilityList CognitiveServicesDomainAvailabilityList(bool? isSubdomainAvailable = null, string reason = null, string subdomainName = null, string domainAvailabilityType = null, string kind = null)
        {
            return new CognitiveServicesDomainAvailabilityList(
                isSubdomainAvailable,
                reason,
                subdomainName,
                domainAvailabilityType,
                kind,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesPrivateLinkResource"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Resource properties. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesPrivateLinkResource"/> instance for mocking. </returns>
        public static CognitiveServicesPrivateLinkResource CognitiveServicesPrivateLinkResource(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CognitiveServicesPrivateLinkResourceProperties properties = null)
        {
            return new CognitiveServicesPrivateLinkResource(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesPrivateLinkResourceProperties"/>. </summary>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <param name="displayName"> The private link resource display name. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesPrivateLinkResourceProperties"/> instance for mocking. </returns>
        public static CognitiveServicesPrivateLinkResourceProperties CognitiveServicesPrivateLinkResourceProperties(string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null, string displayName = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new CognitiveServicesPrivateLinkResourceProperties(groupId, requiredMembers?.ToList(), requiredZoneNames?.ToList(), displayName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServices.CognitiveServicesAccountDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="sku"> The resource model definition representing SKU. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties"> Properties of Cognitive Services account deployment. </param>
        /// <returns> A new <see cref="CognitiveServices.CognitiveServicesAccountDeploymentData"/> instance for mocking. </returns>
        public static CognitiveServicesAccountDeploymentData CognitiveServicesAccountDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CognitiveServicesSku sku = null, ETag? etag = null, CognitiveServicesAccountDeploymentProperties properties = null)
        {
            return new CognitiveServicesAccountDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                sku,
                etag,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesAccountDeploymentProperties"/>. </summary>
        /// <param name="provisioningState"> Gets the status of the resource at the time the operation was called. </param>
        /// <param name="model"> Properties of Cognitive Services account deployment model. </param>
        /// <param name="scaleSettings"> Properties of Cognitive Services account deployment model. </param>
        /// <param name="capabilities"> The capabilities. </param>
        /// <param name="raiPolicyName"> The name of RAI policy. </param>
        /// <param name="callRateLimit"> The call rate limit Cognitive Services account. </param>
        /// <param name="rateLimits"></param>
        /// <param name="versionUpgradeOption"> Deployment model version upgrade option. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesAccountDeploymentProperties"/> instance for mocking. </returns>
        public static CognitiveServicesAccountDeploymentProperties CognitiveServicesAccountDeploymentProperties(CognitiveServicesAccountDeploymentProvisioningState? provisioningState = null, CognitiveServicesAccountDeploymentModel model = null, CognitiveServicesAccountDeploymentScaleSettings scaleSettings = null, IReadOnlyDictionary<string, string> capabilities = null, string raiPolicyName = null, ServiceAccountCallRateLimit callRateLimit = null, IEnumerable<ServiceAccountThrottlingRule> rateLimits = null, DeploymentModelVersionUpgradeOption? versionUpgradeOption = null)
        {
            capabilities ??= new Dictionary<string, string>();
            rateLimits ??= new List<ServiceAccountThrottlingRule>();

            return new CognitiveServicesAccountDeploymentProperties(
                provisioningState,
                model,
                scaleSettings,
                capabilities,
                raiPolicyName,
                callRateLimit,
                rateLimits?.ToList(),
                versionUpgradeOption,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CognitiveServicesAccountDeploymentScaleSettings"/>. </summary>
        /// <param name="scaleType"> Deployment scale type. </param>
        /// <param name="capacity"> Deployment capacity. </param>
        /// <param name="activeCapacity"> Deployment active capacity. This value might be different from `capacity` if customer recently updated `capacity`. </param>
        /// <returns> A new <see cref="Models.CognitiveServicesAccountDeploymentScaleSettings"/> instance for mocking. </returns>
        public static CognitiveServicesAccountDeploymentScaleSettings CognitiveServicesAccountDeploymentScaleSettings(CognitiveServicesAccountDeploymentScaleType? scaleType = null, int? capacity = null, int? activeCapacity = null)
        {
            return new CognitiveServicesAccountDeploymentScaleSettings(scaleType, capacity, activeCapacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServices.CommitmentPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="kind"> The Kind of the resource. </param>
        /// <param name="sku"> The resource model definition representing SKU. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="properties"> Properties of Cognitive Services account commitment plan. </param>
        /// <returns> A new <see cref="CognitiveServices.CommitmentPlanData"/> instance for mocking. </returns>
        public static CommitmentPlanData CommitmentPlanData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string kind = null, CognitiveServicesSku sku = null, IDictionary<string, string> tags = null, AzureLocation? location = null, CommitmentPlanProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CommitmentPlanData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                kind,
                sku,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommitmentPlanProperties"/>. </summary>
        /// <param name="provisioningState"> Gets the status of the resource at the time the operation was called. </param>
        /// <param name="commitmentPlanGuid"> Commitment plan guid. </param>
        /// <param name="hostingModel"> Account hosting model. </param>
        /// <param name="planType"> Commitment plan type. </param>
        /// <param name="current"> Cognitive Services account commitment period. </param>
        /// <param name="autoRenew"> AutoRenew commitment plan. </param>
        /// <param name="next"> Cognitive Services account commitment period. </param>
        /// <param name="last"> Cognitive Services account commitment period. </param>
        /// <param name="provisioningIssues"> The list of ProvisioningIssue. </param>
        /// <returns> A new <see cref="Models.CommitmentPlanProperties"/> instance for mocking. </returns>
        public static CommitmentPlanProperties CommitmentPlanProperties(CommitmentPlanProvisioningState? provisioningState = null, Guid? commitmentPlanGuid = null, ServiceAccountHostingModel? hostingModel = null, string planType = null, CommitmentPeriod current = null, bool? autoRenew = null, CommitmentPeriod next = null, CommitmentPeriod last = null, IEnumerable<string> provisioningIssues = null)
        {
            provisioningIssues ??= new List<string>();

            return new CommitmentPlanProperties(
                provisioningState,
                commitmentPlanGuid,
                hostingModel,
                planType,
                current,
                autoRenew,
                next,
                last,
                provisioningIssues?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommitmentPeriod"/>. </summary>
        /// <param name="tier"> Commitment period commitment tier. </param>
        /// <param name="count"> Commitment period commitment count. </param>
        /// <param name="quota"> Cognitive Services account commitment quota. </param>
        /// <param name="startOn"> Commitment period start date. </param>
        /// <param name="endOn"> Commitment period end date. </param>
        /// <returns> A new <see cref="Models.CommitmentPeriod"/> instance for mocking. </returns>
        public static CommitmentPeriod CommitmentPeriod(string tier = null, int? count = null, CommitmentQuota quota = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null)
        {
            return new CommitmentPeriod(
                tier,
                count,
                quota,
                startOn,
                endOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="CognitiveServices.CommitmentPlanAccountAssociationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="accountId"> The Azure resource id of the account. </param>
        /// <returns> A new <see cref="CognitiveServices.CommitmentPlanAccountAssociationData"/> instance for mocking. </returns>
        public static CommitmentPlanAccountAssociationData CommitmentPlanAccountAssociationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string accountId = null)
        {
            return new CommitmentPlanAccountAssociationData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                accountId,
                serializedAdditionalRawData: null);
        }
    }
}
