// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.AnomalyDetector.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class Request
    {
        /// <summary>
        /// Initializes a new instance of the Request class.
        /// </summary>
        public Request()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Request class.
        /// </summary>
        /// <param name="series">Time series data points. Points should be
        /// sorted by timestamp in ascending order to match the anomaly
        /// detection result. If the data is not sorted correctly or there is
        /// duplicated timestamp, the API will not work. In such case, an error
        /// message will be returned.</param>
        /// <param name="granularity">Possible values include: 'yearly',
        /// 'monthly', 'weekly', 'daily', 'hourly', 'minutely',
        /// 'secondly'</param>
        /// <param name="customInterval">Custom Interval is used to set
        /// non-standard time interval, for example, if the series is 5
        /// minutes, request can be set as {"granularity":"minutely",
        /// "customInterval":5}.</param>
        /// <param name="period">Optional argument, periodic value of a time
        /// series. If the value is null or does not present, the API will
        /// determine the period automatically.</param>
        /// <param name="maxAnomalyRatio">Optional argument, advanced model
        /// parameter, max anomaly ratio in a time series.</param>
        /// <param name="sensitivity">Optional argument, advanced model
        /// parameter, between 0-99, the lower the value is, the larger the
        /// margin value will be which means less anomalies will be
        /// accepted.</param>
        public Request(IList<Point> series, Granularity granularity, int? customInterval = default(int?), int? period = default(int?), double? maxAnomalyRatio = default(double?), int? sensitivity = default(int?))
        {
            Series = series;
            Granularity = granularity;
            CustomInterval = customInterval;
            Period = period;
            MaxAnomalyRatio = maxAnomalyRatio;
            Sensitivity = sensitivity;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets time series data points. Points should be sorted by
        /// timestamp in ascending order to match the anomaly detection result.
        /// If the data is not sorted correctly or there is duplicated
        /// timestamp, the API will not work. In such case, an error message
        /// will be returned.
        /// </summary>
        [JsonProperty(PropertyName = "series")]
        public IList<Point> Series { get; set; }

        /// <summary>
        /// Gets or sets possible values include: 'yearly', 'monthly',
        /// 'weekly', 'daily', 'hourly', 'minutely', 'secondly'
        /// </summary>
        [JsonProperty(PropertyName = "granularity")]
        public Granularity Granularity { get; set; }

        /// <summary>
        /// Gets or sets custom Interval is used to set non-standard time
        /// interval, for example, if the series is 5 minutes, request can be
        /// set as {"granularity":"minutely", "customInterval":5}.
        /// </summary>
        [JsonProperty(PropertyName = "customInterval")]
        public int? CustomInterval { get; set; }

        /// <summary>
        /// Gets or sets optional argument, periodic value of a time series. If
        /// the value is null or does not present, the API will determine the
        /// period automatically.
        /// </summary>
        [JsonProperty(PropertyName = "period")]
        public int? Period { get; set; }

        /// <summary>
        /// Gets or sets optional argument, advanced model parameter, max
        /// anomaly ratio in a time series.
        /// </summary>
        [JsonProperty(PropertyName = "maxAnomalyRatio")]
        public double? MaxAnomalyRatio { get; set; }

        /// <summary>
        /// Gets or sets optional argument, advanced model parameter, between
        /// 0-99, the lower the value is, the larger the margin value will be
        /// which means less anomalies will be accepted.
        /// </summary>
        [JsonProperty(PropertyName = "sensitivity")]
        public int? Sensitivity { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Series == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Series");
            }
            if (Series != null)
            {
                foreach (var element in Series)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
