// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.AnomalyDetector.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    public partial class LastDetectResponse
    {
        /// <summary>
        /// Initializes a new instance of the LastDetectResponse class.
        /// </summary>
        public LastDetectResponse()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the LastDetectResponse class.
        /// </summary>
        /// <param name="period">Frequency extracted from the series, zero
        /// means no recurrent pattern has been found.</param>
        /// <param name="suggestedWindow">Suggested input series points needed
        /// for detecting the latest point.</param>
        /// <param name="expectedValue">Expected value of the latest
        /// point.</param>
        /// <param name="upperMargin">Upper margin of the latest point.
        /// UpperMargin is used to calculate upperBoundary, which equals to
        /// expectedValue + (100 - marginScale)*upperMargin. If the value of
        /// latest point is between upperBoundary and lowerBoundary, it should
        /// be treated as normal value. By adjusting marginScale value, anomaly
        /// status of latest point can be changed.</param>
        /// <param name="lowerMargin">Lower margin of the latest point.
        /// LowerMargin is used to calculate lowerBoundary, which equals to
        /// expectedValue - (100 - marginScale)*lowerMargin. </param>
        /// <param name="isAnomaly">Anomaly status of the latest point, true
        /// means the latest point is an anomaly either in negative direction
        /// or positive direction.</param>
        /// <param name="isNegativeAnomaly">Anomaly status in negative
        /// direction of the latest point. True means the latest point is an
        /// anomaly and its real value is smaller than the expected
        /// one.</param>
        /// <param name="isPositiveAnomaly">Anomaly status in positive
        /// direction of the latest point. True means the latest point is an
        /// anomaly and its real value is larger than the expected one.</param>
        public LastDetectResponse(int period, int suggestedWindow, double expectedValue, double upperMargin, double lowerMargin, bool isAnomaly, bool isNegativeAnomaly, bool isPositiveAnomaly)
        {
            Period = period;
            SuggestedWindow = suggestedWindow;
            ExpectedValue = expectedValue;
            UpperMargin = upperMargin;
            LowerMargin = lowerMargin;
            IsAnomaly = isAnomaly;
            IsNegativeAnomaly = isNegativeAnomaly;
            IsPositiveAnomaly = isPositiveAnomaly;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets frequency extracted from the series, zero means no
        /// recurrent pattern has been found.
        /// </summary>
        [JsonProperty(PropertyName = "period")]
        public int Period { get; set; }

        /// <summary>
        /// Gets or sets suggested input series points needed for detecting the
        /// latest point.
        /// </summary>
        [JsonProperty(PropertyName = "suggestedWindow")]
        public int SuggestedWindow { get; set; }

        /// <summary>
        /// Gets or sets expected value of the latest point.
        /// </summary>
        [JsonProperty(PropertyName = "expectedValue")]
        public double ExpectedValue { get; set; }

        /// <summary>
        /// Gets or sets upper margin of the latest point. UpperMargin is used
        /// to calculate upperBoundary, which equals to expectedValue + (100 -
        /// marginScale)*upperMargin. If the value of latest point is between
        /// upperBoundary and lowerBoundary, it should be treated as normal
        /// value. By adjusting marginScale value, anomaly status of latest
        /// point can be changed.
        /// </summary>
        [JsonProperty(PropertyName = "upperMargin")]
        public double UpperMargin { get; set; }

        /// <summary>
        /// Gets or sets lower margin of the latest point. LowerMargin is used
        /// to calculate lowerBoundary, which equals to expectedValue - (100 -
        /// marginScale)*lowerMargin.
        /// </summary>
        [JsonProperty(PropertyName = "lowerMargin")]
        public double LowerMargin { get; set; }

        /// <summary>
        /// Gets or sets anomaly status of the latest point, true means the
        /// latest point is an anomaly either in negative direction or positive
        /// direction.
        /// </summary>
        [JsonProperty(PropertyName = "isAnomaly")]
        public bool IsAnomaly { get; set; }

        /// <summary>
        /// Gets or sets anomaly status in negative direction of the latest
        /// point. True means the latest point is an anomaly and its real value
        /// is smaller than the expected one.
        /// </summary>
        [JsonProperty(PropertyName = "isNegativeAnomaly")]
        public bool IsNegativeAnomaly { get; set; }

        /// <summary>
        /// Gets or sets anomaly status in positive direction of the latest
        /// point. True means the latest point is an anomaly and its real value
        /// is larger than the expected one.
        /// </summary>
        [JsonProperty(PropertyName = "isPositiveAnomaly")]
        public bool IsPositiveAnomaly { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            //Nothing to validate
        }
    }
}
