// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.AnomalyDetector.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class ChangePointDetectRequest
    {
        /// <summary>
        /// Initializes a new instance of the ChangePointDetectRequest class.
        /// </summary>
        public ChangePointDetectRequest()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ChangePointDetectRequest class.
        /// </summary>
        /// <param name="series">Time series data points. Points should be
        /// sorted by timestamp in ascending order to match the change point
        /// detection result.</param>
        /// <param name="granularity">Can only be one of yearly, monthly,
        /// weekly, daily, hourly, minutely or secondly. Granularity is used
        /// for verify whether input series is valid. Possible values include:
        /// 'yearly', 'monthly', 'weekly', 'daily', 'hourly', 'minutely',
        /// 'secondly'</param>
        /// <param name="customInterval">Custom Interval is used to set
        /// non-standard time interval, for example, if the series is 5
        /// minutes, request can be set as {"granularity":"minutely",
        /// "customInterval":5}.</param>
        /// <param name="period">Optional argument, periodic value of a time
        /// series. If the value is null or does not present, the API will
        /// determine the period automatically.</param>
        /// <param name="stableTrendWindow">Optional argument, advanced model
        /// parameter, a default stableTrendWindow will be used in
        /// detection.</param>
        /// <param name="threshold">Optional argument, advanced model
        /// parameter, between 0.0-1.0, the lower the value is, the larger the
        /// trend error will be which means less change point will be
        /// accepted.</param>
        public ChangePointDetectRequest(IList<Point> series, Granularity granularity, int? customInterval = default(int?), int? period = default(int?), int? stableTrendWindow = default(int?), double? threshold = default(double?))
        {
            Series = series;
            Granularity = granularity;
            CustomInterval = customInterval;
            Period = period;
            StableTrendWindow = stableTrendWindow;
            Threshold = threshold;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets time series data points. Points should be sorted by
        /// timestamp in ascending order to match the change point detection
        /// result.
        /// </summary>
        [JsonProperty(PropertyName = "series")]
        public IList<Point> Series { get; set; }

        /// <summary>
        /// Gets or sets can only be one of yearly, monthly, weekly, daily,
        /// hourly, minutely or secondly. Granularity is used for verify
        /// whether input series is valid. Possible values include: 'yearly',
        /// 'monthly', 'weekly', 'daily', 'hourly', 'minutely', 'secondly'
        /// </summary>
        [JsonProperty(PropertyName = "granularity")]
        public Granularity Granularity { get; set; }

        /// <summary>
        /// Gets or sets custom Interval is used to set non-standard time
        /// interval, for example, if the series is 5 minutes, request can be
        /// set as {"granularity":"minutely", "customInterval":5}.
        /// </summary>
        [JsonProperty(PropertyName = "customInterval")]
        public int? CustomInterval { get; set; }

        /// <summary>
        /// Gets or sets optional argument, periodic value of a time series. If
        /// the value is null or does not present, the API will determine the
        /// period automatically.
        /// </summary>
        [JsonProperty(PropertyName = "period")]
        public int? Period { get; set; }

        /// <summary>
        /// Gets or sets optional argument, advanced model parameter, a default
        /// stableTrendWindow will be used in detection.
        /// </summary>
        [JsonProperty(PropertyName = "stableTrendWindow")]
        public int? StableTrendWindow { get; set; }

        /// <summary>
        /// Gets or sets optional argument, advanced model parameter, between
        /// 0.0-1.0, the lower the value is, the larger the trend error will be
        /// which means less change point will be accepted.
        /// </summary>
        [JsonProperty(PropertyName = "threshold")]
        public double? Threshold { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Series == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Series");
            }
            if (Series != null)
            {
                foreach (var element in Series)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
