// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.AnomalyDetector
{
    using Microsoft.Rest;
    using Models;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// The Anomaly Detector API detects anomalies automatically in time series
    /// data. It supports two kinds of mode, one is for stateless using,
    /// another is for stateful using. In stateless mode, there are three
    /// functionalities. Entire Detect is for detecting the whole series with
    /// model trained by the time series, Last Detect is detecting last point
    /// with model trained by points before. ChangePoint Detect is for
    /// detecting trend changes in time series. In stateful mode, user can
    /// store time series, the stored time series will be used for detection
    /// anomalies. Under this mode, user can still use the above three
    /// functionalities by only giving a time range without preparing time
    /// series in client side. Besides the above three functionalities,
    /// stateful model also provide group based detection and labeling service.
    /// By leveraging labeling service user can provide labels for each
    /// detection result, these labels will be used for retuning or
    /// regenerating detection models. Inconsistency detection is a kind of
    /// group based detection, this detection will find inconsistency ones in a
    /// set of time series. By using anomaly detector service, business
    /// customers can discover incidents and establish a logic flow for root
    /// cause analysis.
    /// </summary>
    public partial interface IAnomalyDetectorClient : System.IDisposable
    {
        /// <summary>
        /// The base URI of the service.
        /// </summary>

        /// <summary>
        /// Gets or sets json serialization settings.
        /// </summary>
        JsonSerializerSettings SerializationSettings { get; }

        /// <summary>
        /// Gets or sets json deserialization settings.
        /// </summary>
        JsonSerializerSettings DeserializationSettings { get; }

        /// <summary>
        /// Supported Cognitive Services endpoints (protocol and hostname, for
        /// example: https://westus2.api.cognitive.microsoft.com).
        /// </summary>
        string Endpoint { get; set; }

        /// <summary>
        /// Subscription credentials which uniquely identify client
        /// subscription.
        /// </summary>
        ServiceClientCredentials Credentials { get; }


        /// <summary>
        /// Detect anomalies for the entire series in batch.
        /// </summary>
        /// <remarks>
        /// This operation generates a model using an entire series, each point
        /// is detected with the same model. With this method, points before
        /// and after a certain point are used to determine whether it is an
        /// anomaly. The entire detection can give user an overall status of
        /// the time series.
        /// </remarks>
        /// <param name='body'>
        /// Time series points and period if needed. Advanced model parameters
        /// can also be set in the request.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<EntireDetectResponse>> EntireDetectWithHttpMessagesAsync(Request body, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Detect anomaly status of the latest point in time series.
        /// </summary>
        /// <remarks>
        /// This operation generates a model using points before the latest
        /// one. With this method, only historical points are used to determine
        /// whether the target point is an anomaly. The latest point detecting
        /// operation matches the scenario of real-time monitoring of business
        /// metrics.
        /// </remarks>
        /// <param name='body'>
        /// Time series points and period if needed. Advanced model parameters
        /// can also be set in the request.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<LastDetectResponse>> LastDetectWithHttpMessagesAsync(Request body, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Detect change point for the entire series
        /// </summary>
        /// <remarks>
        /// Evaluate change point score of every series point
        /// </remarks>
        /// <param name='body'>
        /// Time series points and granularity is needed. Advanced model
        /// parameters can also be set in the request if needed.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ChangePointDetectResponse>> ChangePointDetectWithHttpMessagesAsync(ChangePointDetectRequest body, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

    }
}
