// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.AnomalyDetector
{
    using Models;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for AnomalyDetectorClient.
    /// </summary>
    public static partial class AnomalyDetectorClientExtensions
    {
            /// <summary>
            /// Detect anomalies for the entire series in batch.
            /// </summary>
            /// <remarks>
            /// This operation generates a model using an entire series, each point is
            /// detected with the same model. With this method, points before and after a
            /// certain point are used to determine whether it is an anomaly. The entire
            /// detection can give user an overall status of the time series.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='body'>
            /// Time series points and period if needed. Advanced model parameters can also
            /// be set in the request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<EntireDetectResponse> EntireDetectAsync(this IAnomalyDetectorClient operations, Request body, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EntireDetectWithHttpMessagesAsync(body, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Detect anomaly status of the latest point in time series.
            /// </summary>
            /// <remarks>
            /// This operation generates a model using points before the latest one. With
            /// this method, only historical points are used to determine whether the
            /// target point is an anomaly. The latest point detecting operation matches
            /// the scenario of real-time monitoring of business metrics.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='body'>
            /// Time series points and period if needed. Advanced model parameters can also
            /// be set in the request.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<LastDetectResponse> LastDetectAsync(this IAnomalyDetectorClient operations, Request body, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.LastDetectWithHttpMessagesAsync(body, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Detect change point for the entire series
            /// </summary>
            /// <remarks>
            /// Evaluate change point score of every series point
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='body'>
            /// Time series points and granularity is needed. Advanced model parameters can
            /// also be set in the request if needed.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ChangePointDetectResponse> ChangePointDetectAsync(this IAnomalyDetectorClient operations, ChangePointDetectRequest body, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ChangePointDetectWithHttpMessagesAsync(body, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
