// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.Language.Text.Samples
{
    public partial class Samples_TextAnalysisClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulDynamicClassificationRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "DynamicClassification",
                parameters = new
                {
                    categories = new object[]
            {
"Health",
"Politics",
"Music",
"Sports"
            },
                    classificationType = "Multi",
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "The WHO is issuing a warning about Monkey Pox.",
},
new
{
id = "2",
language = "en",
text = "Mo Salah plays in Liverpool FC in England.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulDynamicClassificationRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "DynamicClassification",
                parameters = new
                {
                    categories = new object[]
            {
"Health",
"Politics",
"Music",
"Sports"
            },
                    classificationType = "Multi",
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "The WHO is issuing a warning about Monkey Pox.",
},
new
{
id = "2",
language = "en",
text = "Mo Salah plays in Liverpool FC in England.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulDynamicClassificationRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextDynamicClassificationInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "The WHO is issuing a warning about Monkey Pox.")
{
Language = "en",
}, new MultiLanguageInput("2", "Mo Salah plays in Liverpool FC in England.")
{
Language = "en",
}},
                },
                ActionContent = new DynamicClassificationActionContent(new string[] { "Health", "Politics", "Music", "Sports" })
                {
                    ModelVersion = "latest",
                    ClassificationType = ClassificationType.Multi,
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulDynamicClassificationRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextDynamicClassificationInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "The WHO is issuing a warning about Monkey Pox.")
{
Language = "en",
}, new MultiLanguageInput("2", "Mo Salah plays in Liverpool FC in England.")
{
Language = "en",
}},
                },
                ActionContent = new DynamicClassificationActionContent(new string[] { "Health", "Politics", "Music", "Sports" })
                {
                    ModelVersion = "latest",
                    ClassificationType = ClassificationType.Multi,
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityLinkingRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityLinking",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "Microsoft was founded by Bill Gates and Paul Allen.",
},
new
{
id = "2",
language = "en",
text = "Pike place market is my favorite Seattle attraction.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityLinkingRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityLinking",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "Microsoft was founded by Bill Gates and Paul Allen.",
},
new
{
id = "2",
language = "en",
text = "Pike place market is my favorite Seattle attraction.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityLinkingRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityLinkingInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "Microsoft was founded by Bill Gates and Paul Allen.")
{
Language = "en",
}, new MultiLanguageInput("2", "Pike place market is my favorite Seattle attraction.")
{
Language = "en",
}},
                },
                ActionContent = new EntityLinkingActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityLinkingRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityLinkingInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "Microsoft was founded by Bill Gates and Paul Allen.")
{
Language = "en",
}, new MultiLanguageInput("2", "Pike place market is my favorite Seattle attraction.")
{
Language = "en",
}},
                },
                ActionContent = new EntityLinkingActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionExclusionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    exclusionList = new object[]
            {
"Numeric"
            },
                    overlapPolicy = new
                    {
                        policyKind = "allowOverlap",
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "2",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
},
new
{
id = "3",
language = "en",
text = "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionExclusionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    exclusionList = new object[]
            {
"Numeric"
            },
                    overlapPolicy = new
                    {
                        policyKind = "allowOverlap",
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "2",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
},
new
{
id = "3",
language = "en",
text = "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionExclusionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("2", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}, new MultiLanguageInput("3", "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    Exclusions = { EntityCategory.Numeric },
                    OverlapPolicy = new AllowOverlapEntityPolicyType(),
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionExclusionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("2", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}, new MultiLanguageInput("3", "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    Exclusions = { EntityCategory.Numeric },
                    OverlapPolicy = new AllowOverlapEntityPolicyType(),
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionInclusionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    inclusionList = new object[]
            {
"Location"
            },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "2",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
},
new
{
id = "3",
language = "en",
text = "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionInclusionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    inclusionList = new object[]
            {
"Location"
            },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "2",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
},
new
{
id = "3",
language = "en",
text = "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionInclusionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("2", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}, new MultiLanguageInput("3", "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    Inclusions = { EntityCategory.Location },
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionInclusionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("2", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}, new MultiLanguageInput("3", "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    Inclusions = { EntityCategory.Location },
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionInferenceOptionsRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    inferenceOptions = new
                    {
                        excludeNormalizedValues = true,
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionInferenceOptionsRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    inferenceOptions = new
                    {
                        excludeNormalizedValues = true,
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionInferenceOptionsRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    InferenceOptions = new EntityInferenceConfig
                    {
                        ExcludeNormalizedValues = true,
                    },
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionInferenceOptionsRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    InferenceOptions = new EntityInferenceConfig
                    {
                        ExcludeNormalizedValues = true,
                    },
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionOverlapPolicy()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    overlapPolicy = new
                    {
                        policyKind = "matchLongest",
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "4",
language = "en",
text = "25th April Meeting was an intresting one. At least we gont to experience the WorldCup",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionOverlapPolicy_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    overlapPolicy = new
                    {
                        policyKind = "matchLongest",
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "4",
language = "en",
text = "25th April Meeting was an intresting one. At least we gont to experience the WorldCup",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionOverlapPolicy_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("4", "25th April Meeting was an intresting one. At least we gont to experience the WorldCup")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    OverlapPolicy = new MatchLongestEntityPolicyType(),
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionOverlapPolicy_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("4", "25th April Meeting was an intresting one. At least we gont to experience the WorldCup")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    OverlapPolicy = new MatchLongestEntityPolicyType(),
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    overlapPolicy = new
                    {
                        policyKind = "allowOverlap",
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "2",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
},
new
{
id = "3",
language = "en",
text = "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.",
},
new
{
id = "4",
language = "en",
text = "25th April Meeting was an intresting one. At least we gont to experience the WorldCup",
},
new
{
id = "5",
language = "en",
text = "My IP is 127.12.1.1 and my phone   number is 5555555555",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "EntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    overlapPolicy = new
                    {
                        policyKind = "allowOverlap",
                    },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "2",
language = "en",
text = "When I was 5 years old I had $90.00 dollars to my name.",
},
new
{
id = "3",
language = "en",
text = "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.",
},
new
{
id = "4",
language = "en",
text = "25th April Meeting was an intresting one. At least we gont to experience the WorldCup",
},
new
{
id = "5",
language = "en",
text = "My IP is 127.12.1.1 and my phone   number is 5555555555",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulEntityRecognitionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("2", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}, new MultiLanguageInput("3", "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.")
{
Language = "en",
}, new MultiLanguageInput("4", "25th April Meeting was an intresting one. At least we gont to experience the WorldCup")
{
Language = "en",
}, new MultiLanguageInput("5", "My IP is 127.12.1.1 and my phone   number is 5555555555")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    OverlapPolicy = new AllowOverlapEntityPolicyType(),
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulEntityRecognitionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextEntityRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("2", "When I was 5 years old I had $90.00 dollars to my name.")
{
Language = "en",
}, new MultiLanguageInput("3", "When we flew from LAX it seemed like we were moving at 10 meters per second. I was lucky to see Amsterdam, Effile Tower, and the Nile.")
{
Language = "en",
}, new MultiLanguageInput("4", "25th April Meeting was an intresting one. At least we gont to experience the WorldCup")
{
Language = "en",
}, new MultiLanguageInput("5", "My IP is 127.12.1.1 and my phone   number is 5555555555")
{
Language = "en",
}},
                },
                ActionContent = new EntitiesActionContent
                {
                    ModelVersion = "latest",
                    OverlapPolicy = new AllowOverlapEntityPolicyType(),
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulKeyPhraseExtractionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "KeyPhraseExtraction",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "Microsoft was founded by Bill Gates and Paul Allen.",
},
new
{
id = "2",
language = "en",
text = "Text Analytics is one of the Azure Cognitive Services.",
},
new
{
id = "3",
language = "en",
text = "My cat might need to see a veterinarian.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulKeyPhraseExtractionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "KeyPhraseExtraction",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "Microsoft was founded by Bill Gates and Paul Allen.",
},
new
{
id = "2",
language = "en",
text = "Text Analytics is one of the Azure Cognitive Services.",
},
new
{
id = "3",
language = "en",
text = "My cat might need to see a veterinarian.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulKeyPhraseExtractionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextKeyPhraseExtractionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "Microsoft was founded by Bill Gates and Paul Allen.")
{
Language = "en",
}, new MultiLanguageInput("2", "Text Analytics is one of the Azure Cognitive Services.")
{
Language = "en",
}, new MultiLanguageInput("3", "My cat might need to see a veterinarian.")
{
Language = "en",
}},
                },
                ActionContent = new KeyPhraseActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulKeyPhraseExtractionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextKeyPhraseExtractionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "Microsoft was founded by Bill Gates and Paul Allen.")
{
Language = "en",
}, new MultiLanguageInput("2", "Text Analytics is one of the Azure Cognitive Services.")
{
Language = "en",
}, new MultiLanguageInput("3", "My cat might need to see a veterinarian.")
{
Language = "en",
}},
                },
                ActionContent = new KeyPhraseActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulLanguageDetectionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "LanguageDetection",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
text = "Hello world",
},
new
{
id = "2",
text = "Bonjour tout le monde",
},
new
{
id = "3",
text = "Hola mundo",
},
new
{
id = "4",
text = "Tumhara naam kya hai?",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulLanguageDetectionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "LanguageDetection",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
text = "Hello world",
},
new
{
id = "2",
text = "Bonjour tout le monde",
},
new
{
id = "3",
text = "Hola mundo",
},
new
{
id = "4",
text = "Tumhara naam kya hai?",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulLanguageDetectionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextLanguageDetectionInput
            {
                TextInput = new LanguageDetectionTextInput
                {
                    LanguageInputs = { new LanguageInput("1", "Hello world"), new LanguageInput("2", "Bonjour tout le monde"), new LanguageInput("3", "Hola mundo"), new LanguageInput("4", "Tumhara naam kya hai?") },
                },
                ActionContent = new LanguageDetectionActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulLanguageDetectionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextLanguageDetectionInput
            {
                TextInput = new LanguageDetectionTextInput
                {
                    LanguageInputs = { new LanguageInput("1", "Hello world"), new LanguageInput("2", "Bonjour tout le monde"), new LanguageInput("3", "Hola mundo"), new LanguageInput("4", "Tumhara naam kya hai?") },
                },
                ActionContent = new LanguageDetectionActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionExclusionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "PiiEntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    excludePiiCategories = new object[]
            {
"USSocialSecurityNumber"
            },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "My SSN is 859-98-0987",
},
new
{
id = "2",
language = "en",
text = "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.",
},
new
{
id = "3",
language = "en",
text = "Is 998.214.865-68 your Brazilian CPF number?",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionExclusionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "PiiEntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    excludePiiCategories = new object[]
            {
"USSocialSecurityNumber"
            },
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "My SSN is 859-98-0987",
},
new
{
id = "2",
language = "en",
text = "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.",
},
new
{
id = "3",
language = "en",
text = "Is 998.214.865-68 your Brazilian CPF number?",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionExclusionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextPiiEntitiesRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "My SSN is 859-98-0987")
{
Language = "en",
}, new MultiLanguageInput("2", "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.")
{
Language = "en",
}, new MultiLanguageInput("3", "Is 998.214.865-68 your Brazilian CPF number?")
{
Language = "en",
}},
                },
                ActionContent = new PiiActionContent
                {
                    ModelVersion = "latest",
                    ExcludePiiCategories = { PiiCategoriesExclude.UsSocialSecurityNumber },
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionExclusionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextPiiEntitiesRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "My SSN is 859-98-0987")
{
Language = "en",
}, new MultiLanguageInput("2", "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.")
{
Language = "en",
}, new MultiLanguageInput("3", "Is 998.214.865-68 your Brazilian CPF number?")
{
Language = "en",
}},
                },
                ActionContent = new PiiActionContent
                {
                    ModelVersion = "latest",
                    ExcludePiiCategories = { PiiCategoriesExclude.UsSocialSecurityNumber },
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRedactionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "PiiEntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    redactionCharacter = "-",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "My SSN is 859-98-0987",
},
new
{
id = "2",
language = "en",
text = "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.",
},
new
{
id = "3",
language = "en",
text = "Is 998.214.865-68 your Brazilian CPF number?",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRedactionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "PiiEntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                    redactionCharacter = "-",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "My SSN is 859-98-0987",
},
new
{
id = "2",
language = "en",
text = "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.",
},
new
{
id = "3",
language = "en",
text = "Is 998.214.865-68 your Brazilian CPF number?",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRedactionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextPiiEntitiesRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "My SSN is 859-98-0987")
{
Language = "en",
}, new MultiLanguageInput("2", "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.")
{
Language = "en",
}, new MultiLanguageInput("3", "Is 998.214.865-68 your Brazilian CPF number?")
{
Language = "en",
}},
                },
                ActionContent = new PiiActionContent
                {
                    ModelVersion = "latest",
                    RedactionCharacter = RedactionCharacter.Minus,
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRedactionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextPiiEntitiesRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "My SSN is 859-98-0987")
{
Language = "en",
}, new MultiLanguageInput("2", "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.")
{
Language = "en",
}, new MultiLanguageInput("3", "Is 998.214.865-68 your Brazilian CPF number?")
{
Language = "en",
}},
                },
                ActionContent = new PiiActionContent
                {
                    ModelVersion = "latest",
                    RedactionCharacter = RedactionCharacter.Minus,
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "PiiEntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "My SSN is 859-98-0987",
},
new
{
id = "2",
language = "en",
text = "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.",
},
new
{
id = "3",
language = "en",
text = "Is 998.214.865-68 your Brazilian CPF number?",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "PiiEntityRecognition",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "My SSN is 859-98-0987",
},
new
{
id = "2",
language = "en",
text = "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.",
},
new
{
id = "3",
language = "en",
text = "Is 998.214.865-68 your Brazilian CPF number?",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextPiiEntitiesRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "My SSN is 859-98-0987")
{
Language = "en",
}, new MultiLanguageInput("2", "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.")
{
Language = "en",
}, new MultiLanguageInput("3", "Is 998.214.865-68 your Brazilian CPF number?")
{
Language = "en",
}},
                },
                ActionContent = new PiiActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulPiiEntityRecognitionRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextPiiEntitiesRecognitionInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "My SSN is 859-98-0987")
{
Language = "en",
}, new MultiLanguageInput("2", "Your ABA number - 111000025 - is the first 9 digits in the lower left hand corner of your personal check.")
{
Language = "en",
}, new MultiLanguageInput("3", "Is 998.214.865-68 your Brazilian CPF number?")
{
Language = "en",
}},
                },
                ActionContent = new PiiActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulSentimentAnalysisRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "SentimentAnalysis",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "Great atmosphere. Close to plenty of restaurants, hotels, and transit! Staff are friendly and helpful.",
}
            },
                },
            });
            Response response = client.AnalyzeText(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulSentimentAnalysisRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                kind = "SentimentAnalysis",
                parameters = new
                {
                    modelVersion = "latest",
                },
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "Great atmosphere. Close to plenty of restaurants, hotels, and transit! Staff are friendly and helpful.",
}
            },
                },
            });
            Response response = await client.AnalyzeTextAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("kind").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeText_SuccessfulSentimentAnalysisRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextSentimentAnalysisInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "Great atmosphere. Close to plenty of restaurants, hotels, and transit! Staff are friendly and helpful.")
{
Language = "en",
}},
                },
                ActionContent = new SentimentAnalysisActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = client.AnalyzeText(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeText_SuccessfulSentimentAnalysisRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            AnalyzeTextInput analyzeTextInput = new TextSentimentAnalysisInput
            {
                TextInput = new MultiLanguageTextInput
                {
                    MultiLanguageInputs = {new MultiLanguageInput("1", "Great atmosphere. Close to plenty of restaurants, hotels, and transit! Staff are friendly and helpful.")
{
Language = "en",
}},
                },
                ActionContent = new SentimentAnalysisActionContent
                {
                    ModelVersion = "latest",
                },
            };
            Response<AnalyzeTextResult> response = await client.AnalyzeTextAsync(analyzeTextInput);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAbstractiveSummarizationTaskResult()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAbstractiveSummarizationTaskResult_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAbstractiveSummarizationTaskResult_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAbstractiveSummarizationTaskResult_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAnalyzeTextJobsMultipleTaskStatusRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAnalyzeTextJobsMultipleTaskStatusRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAnalyzeTextJobsMultipleTaskStatusRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulAnalyzeTextJobsMultipleTaskStatusRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomAbstractiveSummarizationTaskResult()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomAbstractiveSummarizationTaskResult_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomAbstractiveSummarizationTaskResult_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomAbstractiveSummarizationTaskResult_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomHealthcareTaskStatusRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomHealthcareTaskStatusRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomHealthcareTaskStatusRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomHealthcareTaskStatusRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomSentimentAnalysisTaskStatusRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("29fe5bb0-83ae-4f86-85d6-775534dcd2d4"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomSentimentAnalysisTaskStatusRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("29fe5bb0-83ae-4f86-85d6-775534dcd2d4"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomSentimentAnalysisTaskStatusRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("29fe5bb0-83ae-4f86-85d6-775534dcd2d4"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulCustomSentimentAnalysisTaskStatusRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("29fe5bb0-83ae-4f86-85d6-775534dcd2d4"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareDocumentTypeTaskStatusRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("15e4a46b-62e2-4386-8d36-9c2a92bb45dd"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareDocumentTypeTaskStatusRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("15e4a46b-62e2-4386-8d36-9c2a92bb45dd"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareDocumentTypeTaskStatusRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("15e4a46b-62e2-4386-8d36-9c2a92bb45dd"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareDocumentTypeTaskStatusRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("15e4a46b-62e2-4386-8d36-9c2a92bb45dd"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareTaskStatusRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = client.AnalyzeTextOperationStatus(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareTaskStatusRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"), null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("jobId").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("completed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("failed").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("inProgress").ToString());
            Console.WriteLine(result.GetProperty("tasks").GetProperty("total").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareTaskStatusRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = client.AnalyzeTextOperationStatus(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_AnalyzeTextJobState_AnalyzeTextOperationStatus_SuccessfulHealthcareTaskStatusRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Response<AnalyzeTextOperationState> response = await client.AnalyzeTextOperationStatusAsync(Guid.Parse("1780194a-e9c1-4298-b0d4-fdc59ba818a0"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulAbstractiveSummarizationTaskSubmit()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                displayName = "Document Abstractive Summarization Task Example",
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "AbstractiveSummarization",
taskName = "Document Abstractive Summarization Task 1",
parameters = new
{
sentenceCount = 1,
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulAbstractiveSummarizationTaskSubmit_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                displayName = "Document Abstractive Summarization Task Example",
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "AbstractiveSummarization",
taskName = "Document Abstractive Summarization Task 1",
parameters = new
{
sentenceCount = 1,
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulAbstractiveSummarizationTaskSubmit_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new AbstractiveSummarizationOperationAction
{
ActionContent = new AbstractiveSummarizationActionContent
{
SentenceCount = 1,
},
Name = "Document Abstractive Summarization Task 1",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulAbstractiveSummarizationTaskSubmit_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new AbstractiveSummarizationOperationAction
{
ActionContent = new AbstractiveSummarizationActionContent
{
SentenceCount = 1,
},
Name = "Document Abstractive Summarization Task 1",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulAnalyzeTextJobsMultipleTaskSubmitRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                displayName = "Extracting Location & US Region",
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "I had a wonderful trip to Seattle last week.",
},
new
{
id = "2",
language = "en",
text = "I'm flying to NYC tomorrow. See you there.",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "EntityRecognition",
taskName = "Recognize Entities",
parameters = new
{
modelVersion = "latest",
},
},
new
{
kind = "CustomEntityRecognition",
taskName = "Recognize US Regions",
parameters = new
{
projectName = "MyProject",
deploymentName = "MyDeployment",
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulAnalyzeTextJobsMultipleTaskSubmitRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                displayName = "Extracting Location & US Region",
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "I had a wonderful trip to Seattle last week.",
},
new
{
id = "2",
language = "en",
text = "I'm flying to NYC tomorrow. See you there.",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "EntityRecognition",
taskName = "Recognize Entities",
parameters = new
{
modelVersion = "latest",
},
},
new
{
kind = "CustomEntityRecognition",
taskName = "Recognize US Regions",
parameters = new
{
projectName = "MyProject",
deploymentName = "MyDeployment",
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulAnalyzeTextJobsMultipleTaskSubmitRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "I had a wonderful trip to Seattle last week.")
{
Language = "en",
}, new MultiLanguageInput("2", "I'm flying to NYC tomorrow. See you there.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new EntitiesOperationAction
{
ActionContent = new EntitiesActionContent
{
ModelVersion = "latest",
},
Name = "Recognize Entities",
},
new CustomEntitiesOperationAction
{
ActionContent = new CustomEntitiesActionContent("MyProject", "MyDeployment"),
Name = "Recognize US Regions",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulAnalyzeTextJobsMultipleTaskSubmitRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "I had a wonderful trip to Seattle last week.")
{
Language = "en",
}, new MultiLanguageInput("2", "I'm flying to NYC tomorrow. See you there.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new EntitiesOperationAction
{
ActionContent = new EntitiesActionContent
{
ModelVersion = "latest",
},
Name = "Recognize Entities",
},
new CustomEntitiesOperationAction
{
ActionContent = new CustomEntitiesActionContent("MyProject", "MyDeployment"),
Name = "Recognize US Regions",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomAbstractiveSummarizationTaskSubmit()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                displayName = "Document Custom Abstractive Summarization Task Example",
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "CustomAbstractiveSummarization",
taskName = "Custom Document Abstractive Summarization Task 1",
parameters = new
{
projectName = "my_project",
deploymentName = "my_deployment",
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomAbstractiveSummarizationTaskSubmit_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                displayName = "Document Custom Abstractive Summarization Task Example",
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
id = "1",
language = "en",
text = "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "CustomAbstractiveSummarization",
taskName = "Custom Document Abstractive Summarization Task 1",
parameters = new
{
projectName = "my_project",
deploymentName = "my_deployment",
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomAbstractiveSummarizationTaskSubmit_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new CustomAbstractiveSummarizationOperationAction(new CustomAbstractiveSummarizationActionContent("my_project", "my_deployment"))
{
Name = "Custom Document Abstractive Summarization Task 1",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomAbstractiveSummarizationTaskSubmit_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "At Microsoft, we have been on a quest to advance AI beyond existing techniques, by taking a more holistic, human-centric approach to learning and understanding. As Chief Technology Officer of Azure AI Cognitive Services, I have been working with a team of amazing scientists and engineers to turn this quest into a reality. In my role, I enjoy a unique perspective in viewing the relationship among three attributes of human cognition: monolingual text (X), audio or visual sensory signals, (Y) and multilingual (Z). At the intersection of all three, there is magic—what we call XYZ-code as illustrated in Figure 1—a joint representation to create more powerful AI that can speak, hear, see, and understand humans better. We believe XYZ-code will enable us to fulfill our long-term vision: cross-domain transfer learning, spanning modalities and languages. The goal is to have pre-trained models that can jointly learn representations to support a broad range of downstream AI tasks, much in the way humans do today. Over the past five years, we have achieved human performance on benchmarks in conversational speech recognition, machine translation, conversational question answering, machine reading comprehension, and image captioning. These five breakthroughs provided us with strong signals toward our more ambitious aspiration to produce a leap in AI capabilities, achieving multi-sensory and multilingual learning that is closer in line with how humans learn and understand. I believe the joint XYZ-code is a foundational component of this aspiration, if grounded with external knowledge sources in the downstream AI tasks.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new CustomAbstractiveSummarizationOperationAction(new CustomAbstractiveSummarizationActionContent("my_project", "my_deployment"))
{
Name = "Custom Document Abstractive Summarization Task 1",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomHealthcarePostRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "Prescribed 100mg ibuprofen, taken twice daily.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "CustomHealthcare",
parameters = new
{
projectName = "{PROJECT-NAME}",
deploymentName = "{DEPLOYMENT-NAME}",
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomHealthcarePostRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "Prescribed 100mg ibuprofen, taken twice daily.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "CustomHealthcare",
parameters = new
{
projectName = "{PROJECT-NAME}",
deploymentName = "{DEPLOYMENT-NAME}",
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomHealthcarePostRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "Prescribed 100mg ibuprofen, taken twice daily.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new CustomHealthcareOperationAction
{
ActionContent = new CustomHealthcareActionContent("{PROJECT-NAME}", "{DEPLOYMENT-NAME}"),
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomHealthcarePostRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "Prescribed 100mg ibuprofen, taken twice daily.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new CustomHealthcareOperationAction
{
ActionContent = new CustomHealthcareActionContent("{PROJECT-NAME}", "{DEPLOYMENT-NAME}"),
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomSentimentAnalysisTaskSubmit()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "The food is great. But the service is bad.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "CustomSentimentAnalysis",
parameters = new
{
projectName = "{PROJECT-NAME}",
deploymentName = "{DEPLOYMENT-NAME}",
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomSentimentAnalysisTaskSubmit_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "The food is great. But the service is bad.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "CustomSentimentAnalysis",
parameters = new
{
projectName = "{PROJECT-NAME}",
deploymentName = "{DEPLOYMENT-NAME}",
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomSentimentAnalysisTaskSubmit_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "The food is great. But the service is bad.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new CustomSentimentAnalysisOperationAction
{
ActionContent = new CustomSentimentAnalysisActionContent("{PROJECT-NAME}", "{DEPLOYMENT-NAME}"),
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulCustomSentimentAnalysisTaskSubmit_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "The food is great. But the service is bad.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new CustomSentimentAnalysisOperationAction
{
ActionContent = new CustomSentimentAnalysisActionContent("{PROJECT-NAME}", "{DEPLOYMENT-NAME}"),
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcareDocumentTypePostRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "Prescribed 100mg ibuprofen, taken twice daily.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "Healthcare",
parameters = new
{
modelVersion = "latest",
fhirVersion = "4.0.1",
documentType = "DischargeSummary",
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcareDocumentTypePostRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "Prescribed 100mg ibuprofen, taken twice daily.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "Healthcare",
parameters = new
{
modelVersion = "latest",
fhirVersion = "4.0.1",
documentType = "DischargeSummary",
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcareDocumentTypePostRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "Prescribed 100mg ibuprofen, taken twice daily.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new HealthcareOperationAction
{
ActionContent = new HealthcareActionContent
{
ModelVersion = "latest",
FhirVersion = FhirVersion._401,
DocumentType = HealthcareDocumentType.DischargeSummary,
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcareDocumentTypePostRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "Prescribed 100mg ibuprofen, taken twice daily.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new HealthcareOperationAction
{
ActionContent = new HealthcareActionContent
{
ModelVersion = "latest",
FhirVersion = FhirVersion._401,
DocumentType = HealthcareDocumentType.DischargeSummary,
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcarePostRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "Prescribed 100mg ibuprofen, taken twice daily.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "Healthcare",
parameters = new
{
modelVersion = "latest",
},
}
            },
            });
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcarePostRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                analysisInput = new
                {
                    documents = new object[]
            {
new
{
text = "Prescribed 100mg ibuprofen, taken twice daily.",
id = "1",
language = "en",
}
            },
                },
                tasks = new object[]
            {
new
{
kind = "Healthcare",
parameters = new
{
modelVersion = "latest",
},
}
            },
            });
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcarePostRequest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "Prescribed 100mg ibuprofen, taken twice daily.")
{
Language = "en",
}},
            };
            Operation operation = client.AnalyzeTextSubmitOperation(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new HealthcareOperationAction
{
ActionContent = new HealthcareActionContent
{
ModelVersion = "latest",
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextSubmitOperation_SuccessfulHealthcarePostRequest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            MultiLanguageTextInput textInput = new MultiLanguageTextInput
            {
                MultiLanguageInputs = {new MultiLanguageInput("1", "Prescribed 100mg ibuprofen, taken twice daily.")
{
Language = "en",
}},
            };
            Operation operation = await client.AnalyzeTextSubmitOperationAsync(WaitUntil.Completed, textInput, new AnalyzeTextOperationAction[]
            {
new HealthcareOperationAction
{
ActionContent = new HealthcareActionContent
{
ModelVersion = "latest",
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Text_AnalyzeTextCancelOperation_SuccessfulAnalyzeTextJobsCancelRequest()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Operation operation = client.AnalyzeTextCancelOperation(WaitUntil.Completed, Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Text_AnalyzeTextCancelOperation_SuccessfulAnalyzeTextJobsCancelRequest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            TextAnalysisClient client = new TextAnalysisClient(endpoint, credential);

            Operation operation = await client.AnalyzeTextCancelOperationAsync(WaitUntil.Completed, Guid.Parse("c0f2a446-05d9-48fc-ba8f-3ef4af8d0b18"));
        }
    }
}
