// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.Text
{
    internal static partial class TokenSentimentExtensions
    {
        public static string ToSerialString(this TokenSentiment value) => value switch
        {
            TokenSentiment.Positive => "positive",
            TokenSentiment.Mixed => "mixed",
            TokenSentiment.Negative => "negative",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TokenSentiment value.")
        };

        public static TokenSentiment ToTokenSentiment(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positive")) return TokenSentiment.Positive;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "mixed")) return TokenSentiment.Mixed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negative")) return TokenSentiment.Negative;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown TokenSentiment value.");
        }
    }
}
