// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text SentimentAnalysis task input. </summary>
    public partial class TextSentimentAnalysisInput : AnalyzeTextInput
    {
        /// <summary> Initializes a new instance of <see cref="TextSentimentAnalysisInput"/>. </summary>
        public TextSentimentAnalysisInput()
        {
            Kind = AnalyzeTextInputKind.SentimentAnalysis;
        }

        /// <summary> Initializes a new instance of <see cref="TextSentimentAnalysisInput"/>. </summary>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="textInput"> Contains the input documents. </param>
        /// <param name="actionContent"> Sentiment Analysis task parameters. </param>
        internal TextSentimentAnalysisInput(AnalyzeTextInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, MultiLanguageTextInput textInput, SentimentAnalysisActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            TextInput = textInput;
            ActionContent = actionContent;
        }

        /// <summary> Contains the input documents. </summary>
        public MultiLanguageTextInput TextInput { get; set; }
        /// <summary> Sentiment Analysis task parameters. </summary>
        public SentimentAnalysisActionContent ActionContent { get; set; }
    }
}
