// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text PIIEntityRecognition task input. </summary>
    public partial class TextPiiEntitiesRecognitionInput : AnalyzeTextInput
    {
        /// <summary> Initializes a new instance of <see cref="TextPiiEntitiesRecognitionInput"/>. </summary>
        public TextPiiEntitiesRecognitionInput()
        {
            Kind = AnalyzeTextInputKind.PiiEntityRecognition;
        }

        /// <summary> Initializes a new instance of <see cref="TextPiiEntitiesRecognitionInput"/>. </summary>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="textInput"> Contains the input documents. </param>
        /// <param name="actionContent"> Pii task parameters. </param>
        internal TextPiiEntitiesRecognitionInput(AnalyzeTextInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, MultiLanguageTextInput textInput, PiiActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            TextInput = textInput;
            ActionContent = actionContent;
        }

        /// <summary> Contains the input documents. </summary>
        public MultiLanguageTextInput TextInput { get; set; }
        /// <summary> Pii task parameters. </summary>
        public PiiActionContent ActionContent { get; set; }
    }
}
