// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the language detection document analysis task input. </summary>
    public partial class TextLanguageDetectionInput : AnalyzeTextInput
    {
        /// <summary> Initializes a new instance of <see cref="TextLanguageDetectionInput"/>. </summary>
        public TextLanguageDetectionInput()
        {
            Kind = AnalyzeTextInputKind.LanguageDetection;
        }

        /// <summary> Initializes a new instance of <see cref="TextLanguageDetectionInput"/>. </summary>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="textInput"> Documents to be analyzed. </param>
        /// <param name="actionContent"> task parameters. </param>
        internal TextLanguageDetectionInput(AnalyzeTextInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, LanguageDetectionTextInput textInput, LanguageDetectionActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            TextInput = textInput;
            ActionContent = actionContent;
        }

        /// <summary> Documents to be analyzed. </summary>
        public LanguageDetectionTextInput TextInput { get; set; }
        /// <summary> task parameters. </summary>
        public LanguageDetectionActionContent ActionContent { get; set; }
    }
}
