// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text KeyPhraseExtraction task input. </summary>
    public partial class TextKeyPhraseExtractionInput : AnalyzeTextInput
    {
        /// <summary> Initializes a new instance of <see cref="TextKeyPhraseExtractionInput"/>. </summary>
        public TextKeyPhraseExtractionInput()
        {
            Kind = AnalyzeTextInputKind.KeyPhraseExtraction;
        }

        /// <summary> Initializes a new instance of <see cref="TextKeyPhraseExtractionInput"/>. </summary>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="textInput"> Contains the input documents. </param>
        /// <param name="actionContent"> Key phrase extraction task parameters. </param>
        internal TextKeyPhraseExtractionInput(AnalyzeTextInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, MultiLanguageTextInput textInput, KeyPhraseActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            TextInput = textInput;
            ActionContent = actionContent;
        }

        /// <summary> Contains the input documents. </summary>
        public MultiLanguageTextInput TextInput { get; set; }
        /// <summary> Key phrase extraction task parameters. </summary>
        public KeyPhraseActionContent ActionContent { get; set; }
    }
}
