// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> The entity recognition analyze text input task request. </summary>
    public partial class TextEntityRecognitionInput : AnalyzeTextInput
    {
        /// <summary> Initializes a new instance of <see cref="TextEntityRecognitionInput"/>. </summary>
        public TextEntityRecognitionInput()
        {
            Kind = AnalyzeTextInputKind.EntityRecognition;
        }

        /// <summary> Initializes a new instance of <see cref="TextEntityRecognitionInput"/>. </summary>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="textInput"> The input to be analyzed. </param>
        /// <param name="actionContent"> Task parameters. </param>
        internal TextEntityRecognitionInput(AnalyzeTextInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, MultiLanguageTextInput textInput, EntitiesActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            TextInput = textInput;
            ActionContent = actionContent;
        }

        /// <summary> The input to be analyzed. </summary>
        public MultiLanguageTextInput TextInput { get; set; }
        /// <summary> Task parameters. </summary>
        public EntitiesActionContent ActionContent { get; set; }
    }
}
