// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text Entity linking input. </summary>
    public partial class TextEntityLinkingInput : AnalyzeTextInput
    {
        /// <summary> Initializes a new instance of <see cref="TextEntityLinkingInput"/>. </summary>
        public TextEntityLinkingInput()
        {
            Kind = AnalyzeTextInputKind.EntityLinking;
        }

        /// <summary> Initializes a new instance of <see cref="TextEntityLinkingInput"/>. </summary>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="textInput"> Contains the analysis input to be handled by the service. </param>
        /// <param name="actionContent"> Task parameters. </param>
        internal TextEntityLinkingInput(AnalyzeTextInputKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, MultiLanguageTextInput textInput, EntityLinkingActionContent actionContent) : base(kind, serializedAdditionalRawData)
        {
            TextInput = textInput;
            ActionContent = actionContent;
        }

        /// <summary> Contains the analysis input to be handled by the service. </summary>
        public MultiLanguageTextInput TextInput { get; set; }
        /// <summary> Task parameters. </summary>
        public EntityLinkingActionContent ActionContent { get; set; }
    }
}
