// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core.Extensions;

namespace Azure.AI.Language.Text
{
    /// <summary> Extension methods to add <see cref="TextAnalysisClient"/> to client builder. </summary>
    public static partial class TextAnalysisClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="TextAnalysisClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoint (e.g., https://&lt;resource-name&gt;.api.cognitiveservices.azure.com). </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<TextAnalysisClient, TextAnalysisClientOptions> AddTextAnalysisClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<TextAnalysisClient, TextAnalysisClientOptions>((options) => new TextAnalysisClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="TextAnalysisClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoint (e.g., https://&lt;resource-name&gt;.api.cognitiveservices.azure.com). </param>
        public static IAzureClientBuilder<TextAnalysisClient, TextAnalysisClientOptions> AddTextAnalysisClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<TextAnalysisClient, TextAnalysisClientOptions>((options, cred) => new TextAnalysisClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="TextAnalysisClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<TextAnalysisClient, TextAnalysisClientOptions> AddTextAnalysisClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<TextAnalysisClient, TextAnalysisClientOptions>(configuration);
        }
    }
}
