// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.AI.Language.Text
{
    public partial class TemporalSpanValues : IUtf8JsonSerializable, IJsonModel<TemporalSpanValues>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<TemporalSpanValues>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<TemporalSpanValues>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TemporalSpanValues>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TemporalSpanValues)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Begin))
            {
                writer.WritePropertyName("begin"u8);
                writer.WriteStringValue(Begin);
            }
            if (Optional.IsDefined(End))
            {
                writer.WritePropertyName("end"u8);
                writer.WriteStringValue(End);
            }
            if (Optional.IsDefined(Duration))
            {
                writer.WritePropertyName("duration"u8);
                writer.WriteStringValue(Duration);
            }
            if (Optional.IsDefined(Modifier))
            {
                writer.WritePropertyName("modifier"u8);
                writer.WriteStringValue(Modifier.Value.ToString());
            }
            if (Optional.IsDefined(Timex))
            {
                writer.WritePropertyName("timex"u8);
                writer.WriteStringValue(Timex);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        TemporalSpanValues IJsonModel<TemporalSpanValues>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TemporalSpanValues>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(TemporalSpanValues)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeTemporalSpanValues(document.RootElement, options);
        }

        internal static TemporalSpanValues DeserializeTemporalSpanValues(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string begin = default;
            string end = default;
            string duration = default;
            TemporalModifier? modifier = default;
            string timex = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("begin"u8))
                {
                    begin = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("end"u8))
                {
                    end = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("duration"u8))
                {
                    duration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("modifier"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    modifier = new TemporalModifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("timex"u8))
                {
                    timex = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new TemporalSpanValues(
                begin,
                end,
                duration,
                modifier,
                timex,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<TemporalSpanValues>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TemporalSpanValues>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(TemporalSpanValues)} does not support writing '{options.Format}' format.");
            }
        }

        TemporalSpanValues IPersistableModel<TemporalSpanValues>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<TemporalSpanValues>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeTemporalSpanValues(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(TemporalSpanValues)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<TemporalSpanValues>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TemporalSpanValues FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTemporalSpanValues(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
