// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> represents the Metadata of a date and/or time span. </summary>
    public partial class TemporalSpanMetadata : BaseMetadata
    {
        /// <summary> Initializes a new instance of <see cref="TemporalSpanMetadata"/>. </summary>
        internal TemporalSpanMetadata()
        {
            MetadataKind = MetadataKind.TemporalSpanMetadata;
            SpanValues = new ChangeTrackingList<TemporalSpanValues>();
        }

        /// <summary> Initializes a new instance of <see cref="TemporalSpanMetadata"/>. </summary>
        /// <param name="metadataKind"> The entity Metadata object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="spanValues"> List of temporal spans detected. </param>
        internal TemporalSpanMetadata(MetadataKind metadataKind, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<TemporalSpanValues> spanValues) : base(metadataKind, serializedAdditionalRawData)
        {
            SpanValues = spanValues;
        }

        /// <summary> List of temporal spans detected. </summary>
        public IReadOnlyList<TemporalSpanValues> SpanValues { get; }
    }
}
