// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Represents the confidence scores across all sentiment classes: positive and negative. </summary>
    public partial class TargetConfidenceScoreLabel
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TargetConfidenceScoreLabel"/>. </summary>
        /// <param name="positive"> Confidence score for positive sentiment. </param>
        /// <param name="negative"> Confidence score for negative sentiment. </param>
        internal TargetConfidenceScoreLabel(double positive, double negative)
        {
            Positive = positive;
            Negative = negative;
        }

        /// <summary> Initializes a new instance of <see cref="TargetConfidenceScoreLabel"/>. </summary>
        /// <param name="positive"> Confidence score for positive sentiment. </param>
        /// <param name="negative"> Confidence score for negative sentiment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TargetConfidenceScoreLabel(double positive, double negative, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Positive = positive;
            Negative = negative;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TargetConfidenceScoreLabel"/> for deserialization. </summary>
        internal TargetConfidenceScoreLabel()
        {
        }

        /// <summary> Confidence score for positive sentiment. </summary>
        public double Positive { get; }
        /// <summary> Confidence score for negative sentiment. </summary>
        public double Negative { get; }
    }
}
