// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Represents the Speed entity Metadata model. </summary>
    public partial class SpeedMetadata : BaseMetadata
    {
        /// <summary> Initializes a new instance of <see cref="SpeedMetadata"/>. </summary>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> Unit of measure for speed. </param>
        internal SpeedMetadata(double value, SpeedUnit unit)
        {
            MetadataKind = MetadataKind.SpeedMetadata;
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="SpeedMetadata"/>. </summary>
        /// <param name="metadataKind"> The entity Metadata object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The numeric value that the extracted text denotes. </param>
        /// <param name="unit"> Unit of measure for speed. </param>
        internal SpeedMetadata(MetadataKind metadataKind, IDictionary<string, BinaryData> serializedAdditionalRawData, double value, SpeedUnit unit) : base(metadataKind, serializedAdditionalRawData)
        {
            Value = value;
            Unit = unit;
        }

        /// <summary> Initializes a new instance of <see cref="SpeedMetadata"/> for deserialization. </summary>
        internal SpeedMetadata()
        {
        }

        /// <summary> The numeric value that the extracted text denotes. </summary>
        public double Value { get; }
        /// <summary> Unit of measure for speed. </summary>
        public SpeedUnit Unit { get; }
    }
}
