// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the Sentiment Analysis LRO results. </summary>
    public partial class SentimentOperationResult : AnalyzeTextOperationResult
    {
        /// <summary> Initializes a new instance of <see cref="SentimentOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="results"> The sentiment analysis results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal SentimentOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, SentimentResult results) : base(lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextOperationResultsKind.SentimentAnalysisOperationResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="SentimentOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> Kind of the task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> The sentiment analysis results. </param>
        internal SentimentOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, string name, AnalyzeTextOperationResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, SentimentResult results) : base(lastUpdateDateTime, status, name, kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="SentimentOperationResult"/> for deserialization. </summary>
        internal SentimentOperationResult()
        {
        }

        /// <summary> The sentiment analysis results. </summary>
        public SentimentResult Results { get; }
    }
}
