// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> An object representing the task definition for a Sentiment Analysis task. </summary>
    public partial class SentimentAnalysisOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="SentimentAnalysisOperationAction"/>. </summary>
        public SentimentAnalysisOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.SentimentAnalysis;
        }

        /// <summary> Initializes a new instance of <see cref="SentimentAnalysisOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Parameters for the Sentiment Analysis task. </param>
        internal SentimentAnalysisOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, SentimentAnalysisActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Parameters for the Sentiment Analysis task. </summary>
        public SentimentAnalysisActionContent ActionContent { get; set; }
    }
}
