// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> This object contains information of the prebuilt component of the detected entity. </summary>
    public partial class PrebuiltComponent : EntityComponentInformation
    {
        /// <summary> Initializes a new instance of <see cref="PrebuiltComponent"/>. </summary>
        internal PrebuiltComponent()
        {
            EntityComponentKind = EntityComponentKind.PrebuiltComponent;
        }

        /// <summary> Initializes a new instance of <see cref="PrebuiltComponent"/>. </summary>
        /// <param name="entityComponentKind"> Kind of entity component. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The prebuilt component of an extracted entity type. </param>
        internal PrebuiltComponent(EntityComponentKind entityComponentKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string value) : base(entityComponentKind, serializedAdditionalRawData)
        {
            Value = value;
        }

        /// <summary> The prebuilt component of an extracted entity type. </summary>
        public string Value { get; }
    }
}
