// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> (Optional) describes the PII categories to return. </summary>
    public readonly partial struct PiiCategory : IEquatable<PiiCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PiiCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PiiCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AbaRoutingNumberValue = "ABARoutingNumber";
        private const string ArNationalIdentityNumberValue = "ARNationalIdentityNumber";
        private const string AuBankAccountNumberValue = "AUBankAccountNumber";
        private const string AuDriversLicenseNumberValue = "AUDriversLicenseNumber";
        private const string AuMedicalAccountNumberValue = "AUMedicalAccountNumber";
        private const string AuPassportNumberValue = "AUPassportNumber";
        private const string AuTaxFileNumberValue = "AUTaxFileNumber";
        private const string AuBusinessNumberValue = "AUBusinessNumber";
        private const string AuCompanyNumberValue = "AUCompanyNumber";
        private const string AtIdentityCardValue = "ATIdentityCard";
        private const string AtTaxIdentificationNumberValue = "ATTaxIdentificationNumber";
        private const string AtValueAddedTaxNumberValue = "ATValueAddedTaxNumber";
        private const string AzureDocumentDbauthKeyValue = "AzureDocumentDBAuthKey";
        private const string AzureIaasDatabaseConnectionAndSqlStringValue = "AzureIAASDatabaseConnectionAndSQLString";
        private const string AzureIoTConnectionStringValue = "AzureIoTConnectionString";
        private const string AzurePublishSettingPasswordValue = "AzurePublishSettingPassword";
        private const string AzureRedisCacheStringValue = "AzureRedisCacheString";
        private const string AzureSasValue = "AzureSAS";
        private const string AzureServiceBusStringValue = "AzureServiceBusString";
        private const string AzureStorageAccountKeyValue = "AzureStorageAccountKey";
        private const string AzureStorageAccountGenericValue = "AzureStorageAccountGeneric";
        private const string BeNationalNumberValue = "BENationalNumber";
        private const string BeNationalNumberV2Value = "BENationalNumberV2";
        private const string BeValueAddedTaxNumberValue = "BEValueAddedTaxNumber";
        private const string BrCpfNumberValue = "BRCPFNumber";
        private const string BrLegalEntityNumberValue = "BRLegalEntityNumber";
        private const string BrNationalIdRgValue = "BRNationalIDRG";
        private const string BgUniformCivilNumberValue = "BGUniformCivilNumber";
        private const string CaBankAccountNumberValue = "CABankAccountNumber";
        private const string CaDriversLicenseNumberValue = "CADriversLicenseNumber";
        private const string CaHealthServiceNumberValue = "CAHealthServiceNumber";
        private const string CaPassportNumberValue = "CAPassportNumber";
        private const string CaPersonalHealthIdentificationValue = "CAPersonalHealthIdentification";
        private const string CaSocialInsuranceNumberValue = "CASocialInsuranceNumber";
        private const string ClIdentityCardNumberValue = "CLIdentityCardNumber";
        private const string CnResidentIdentityCardNumberValue = "CNResidentIdentityCardNumber";
        private const string CreditCardNumberValue = "CreditCardNumber";
        private const string HrIdentityCardNumberValue = "HRIdentityCardNumber";
        private const string HrNationalIdNumberValue = "HRNationalIDNumber";
        private const string HrPersonalIdentificationNumberValue = "HRPersonalIdentificationNumber";
        private const string HrPersonalIdentificationOIBNumberV2Value = "HRPersonalIdentificationOIBNumberV2";
        private const string CyIdentityCardValue = "CYIdentityCard";
        private const string CyTaxIdentificationNumberValue = "CYTaxIdentificationNumber";
        private const string CzPersonalIdentityNumberValue = "CZPersonalIdentityNumber";
        private const string CzPersonalIdentityV2Value = "CZPersonalIdentityV2";
        private const string DkPersonalIdentificationNumberValue = "DKPersonalIdentificationNumber";
        private const string DkPersonalIdentificationV2Value = "DKPersonalIdentificationV2";
        private const string DrugEnforcementAgencyNumberValue = "DrugEnforcementAgencyNumber";
        private const string EePersonalIdentificationCodeValue = "EEPersonalIdentificationCode";
        private const string EuDebitCardNumberValue = "EUDebitCardNumber";
        private const string EuDriversLicenseNumberValue = "EUDriversLicenseNumber";
        private const string EuGpsCoordinatesValue = "EUGPSCoordinates";
        private const string EuNationalIdentificationNumberValue = "EUNationalIdentificationNumber";
        private const string EuPassportNumberValue = "EUPassportNumber";
        private const string EuSocialSecurityNumberValue = "EUSocialSecurityNumber";
        private const string EuTaxIdentificationNumberValue = "EUTaxIdentificationNumber";
        private const string FiEuropeanHealthNumberValue = "FIEuropeanHealthNumber";
        private const string FiNationalIdValue = "FINationalID";
        private const string FiNationalIdV2Value = "FINationalIDV2";
        private const string FiPassportNumberValue = "FIPassportNumber";
        private const string FrDriversLicenseNumberValue = "FRDriversLicenseNumber";
        private const string FrHealthInsuranceNumberValue = "FRHealthInsuranceNumber";
        private const string FrNationalIdValue = "FRNationalID";
        private const string FrPassportNumberValue = "FRPassportNumber";
        private const string FrSocialSecurityNumberValue = "FRSocialSecurityNumber";
        private const string FrTaxIdentificationNumberValue = "FRTaxIdentificationNumber";
        private const string FrValueAddedTaxNumberValue = "FRValueAddedTaxNumber";
        private const string DeDriversLicenseNumberValue = "DEDriversLicenseNumber";
        private const string DePassportNumberValue = "DEPassportNumber";
        private const string DeIdentityCardNumberValue = "DEIdentityCardNumber";
        private const string DeTaxIdentificationNumberValue = "DETaxIdentificationNumber";
        private const string DeValueAddedNumberValue = "DEValueAddedNumber";
        private const string GrNationalIdCardValue = "GRNationalIDCard";
        private const string GrNationalIdV2Value = "GRNationalIDV2";
        private const string GrTaxIdentificationNumberValue = "GRTaxIdentificationNumber";
        private const string HkIdentityCardNumberValue = "HKIdentityCardNumber";
        private const string HuValueAddedNumberValue = "HUValueAddedNumber";
        private const string HuPersonalIdentificationNumberValue = "HUPersonalIdentificationNumber";
        private const string HuTaxIdentificationNumberValue = "HUTaxIdentificationNumber";
        private const string InPermanentAccountValue = "INPermanentAccount";
        private const string InUniqueIdentificationNumberValue = "INUniqueIdentificationNumber";
        private const string IdIdentityCardNumberValue = "IDIdentityCardNumber";
        private const string InternationalBankingAccountNumberValue = "InternationalBankingAccountNumber";
        private const string IePersonalPublicServiceNumberValue = "IEPersonalPublicServiceNumber";
        private const string IePersonalPublicServiceNumberV2Value = "IEPersonalPublicServiceNumberV2";
        private const string IlBankAccountNumberValue = "ILBankAccountNumber";
        private const string IlNationalIdValue = "ILNationalID";
        private const string ItDriversLicenseNumberValue = "ITDriversLicenseNumber";
        private const string ItFiscalCodeValue = "ITFiscalCode";
        private const string ItValueAddedTaxNumberValue = "ITValueAddedTaxNumber";
        private const string JpBankAccountNumberValue = "JPBankAccountNumber";
        private const string JpDriversLicenseNumberValue = "JPDriversLicenseNumber";
        private const string JpPassportNumberValue = "JPPassportNumber";
        private const string JpResidentRegistrationNumberValue = "JPResidentRegistrationNumber";
        private const string JpSocialInsuranceNumberValue = "JPSocialInsuranceNumber";
        private const string JpMyNumberCorporateValue = "JPMyNumberCorporate";
        private const string JpMyNumberPersonalValue = "JPMyNumberPersonal";
        private const string JpResidenceCardNumberValue = "JPResidenceCardNumber";
        private const string LvPersonalCodeValue = "LVPersonalCode";
        private const string LtPersonalCodeValue = "LTPersonalCode";
        private const string LuNationalIdentificationNumberNaturalValue = "LUNationalIdentificationNumberNatural";
        private const string LuNationalIdentificationNumberNonNaturalValue = "LUNationalIdentificationNumberNonNatural";
        private const string MyIdentityCardNumberValue = "MYIdentityCardNumber";
        private const string MtIdentityCardNumberValue = "MTIdentityCardNumber";
        private const string MtTaxIdNumberValue = "MTTaxIDNumber";
        private const string NlCitizensServiceNumberValue = "NLCitizensServiceNumber";
        private const string NlCitizensServiceNumberV2Value = "NLCitizensServiceNumberV2";
        private const string NlTaxIdentificationNumberValue = "NLTaxIdentificationNumber";
        private const string NlValueAddedTaxNumberValue = "NLValueAddedTaxNumber";
        private const string NzBankAccountNumberValue = "NZBankAccountNumber";
        private const string NzDriversLicenseNumberValue = "NZDriversLicenseNumber";
        private const string NzInlandRevenueNumberValue = "NZInlandRevenueNumber";
        private const string NzMinistryOfHealthNumberValue = "NZMinistryOfHealthNumber";
        private const string NzSocialWelfareNumberValue = "NZSocialWelfareNumber";
        private const string NoIdentityNumberValue = "NOIdentityNumber";
        private const string PhUnifiedMultiPurposeIdNumberValue = "PHUnifiedMultiPurposeIDNumber";
        private const string PlIdentityCardValue = "PLIdentityCard";
        private const string PlNationalIdValue = "PLNationalID";
        private const string PlNationalIdV2Value = "PLNationalIDV2";
        private const string PlPassportNumberValue = "PLPassportNumber";
        private const string PlTaxIdentificationNumberValue = "PLTaxIdentificationNumber";
        private const string PlRegonNumberValue = "PLREGONNumber";
        private const string PtCitizenCardNumberValue = "PTCitizenCardNumber";
        private const string PtCitizenCardNumberV2Value = "PTCitizenCardNumberV2";
        private const string PtTaxIdentificationNumberValue = "PTTaxIdentificationNumber";
        private const string RoPersonalNumericalCodeValue = "ROPersonalNumericalCode";
        private const string RuPassportNumberDomesticValue = "RUPassportNumberDomestic";
        private const string RuPassportNumberInternationalValue = "RUPassportNumberInternational";
        private const string SaNationalIdValue = "SANationalID";
        private const string SgNationalRegistrationIdentityCardNumberValue = "SGNationalRegistrationIdentityCardNumber";
        private const string SkPersonalNumberValue = "SKPersonalNumber";
        private const string SiTaxIdentificationNumberValue = "SITaxIdentificationNumber";
        private const string SiUniqueMasterCitizenNumberValue = "SIUniqueMasterCitizenNumber";
        private const string ZaIdentificationNumberValue = "ZAIdentificationNumber";
        private const string KrResidentRegistrationNumberValue = "KRResidentRegistrationNumber";
        private const string EsDniValue = "ESDNI";
        private const string EsSocialSecurityNumberValue = "ESSocialSecurityNumber";
        private const string EsTaxIdentificationNumberValue = "ESTaxIdentificationNumber";
        private const string SqlServerConnectionStringValue = "SQLServerConnectionString";
        private const string SeNationalIdValue = "SENationalID";
        private const string SeNationalIdV2Value = "SENationalIDV2";
        private const string SePassportNumberValue = "SEPassportNumber";
        private const string SeTaxIdentificationNumberValue = "SETaxIdentificationNumber";
        private const string SwiftCodeValue = "SWIFTCode";
        private const string ChSocialSecurityNumberValue = "CHSocialSecurityNumber";
        private const string TwNationalIdValue = "TWNationalID";
        private const string TwPassportNumberValue = "TWPassportNumber";
        private const string TwResidentCertificateValue = "TWResidentCertificate";
        private const string ThPopulationIdentificationCodeValue = "THPopulationIdentificationCode";
        private const string TrNationalIdentificationNumberValue = "TRNationalIdentificationNumber";
        private const string UkDriversLicenseNumberValue = "UKDriversLicenseNumber";
        private const string UkElectoralRollNumberValue = "UKElectoralRollNumber";
        private const string UkNationalHealthNumberValue = "UKNationalHealthNumber";
        private const string UkNationalInsuranceNumberValue = "UKNationalInsuranceNumber";
        private const string UkUniqueTaxpayerNumberValue = "UKUniqueTaxpayerNumber";
        private const string UsUkPassportNumberValue = "USUKPassportNumber";
        private const string UsBankAccountNumberValue = "USBankAccountNumber";
        private const string UsDriversLicenseNumberValue = "USDriversLicenseNumber";
        private const string UsIndividualTaxpayerIdentificationValue = "USIndividualTaxpayerIdentification";
        private const string UsSocialSecurityNumberValue = "USSocialSecurityNumber";
        private const string UaPassportNumberDomesticValue = "UAPassportNumberDomestic";
        private const string UaPassportNumberInternationalValue = "UAPassportNumberInternational";
        private const string OrganizationValue = "Organization";
        private const string EmailValue = "Email";
        private const string URLValue = "URL";
        private const string AgeValue = "Age";
        private const string PhoneNumberValue = "PhoneNumber";
        private const string IPAddressValue = "IPAddress";
        private const string DateValue = "Date";
        private const string PersonValue = "Person";
        private const string AddressValue = "Address";
        private const string AllValue = "All";
        private const string DefaultValue = "Default";

        /// <summary> ABA Routing number. </summary>
        public static PiiCategory AbaRoutingNumber { get; } = new PiiCategory(AbaRoutingNumberValue);
        /// <summary> AR National Identity Number. </summary>
        public static PiiCategory ArNationalIdentityNumber { get; } = new PiiCategory(ArNationalIdentityNumberValue);
        /// <summary> AT Identity Card. </summary>
        public static PiiCategory AuBankAccountNumber { get; } = new PiiCategory(AuBankAccountNumberValue);
        /// <summary> AU Driver's License Number. </summary>
        public static PiiCategory AuDriversLicenseNumber { get; } = new PiiCategory(AuDriversLicenseNumberValue);
        /// <summary> AU Medical Account Number. </summary>
        public static PiiCategory AuMedicalAccountNumber { get; } = new PiiCategory(AuMedicalAccountNumberValue);
        /// <summary> AU Passport Number. </summary>
        public static PiiCategory AuPassportNumber { get; } = new PiiCategory(AuPassportNumberValue);
        /// <summary> AU Tax File Number. </summary>
        public static PiiCategory AuTaxFileNumber { get; } = new PiiCategory(AuTaxFileNumberValue);
        /// <summary> AU Business Number. </summary>
        public static PiiCategory AuBusinessNumber { get; } = new PiiCategory(AuBusinessNumberValue);
        /// <summary> AU Company Number. </summary>
        public static PiiCategory AuCompanyNumber { get; } = new PiiCategory(AuCompanyNumberValue);
        /// <summary> AT Identity Card. </summary>
        public static PiiCategory AtIdentityCard { get; } = new PiiCategory(AtIdentityCardValue);
        /// <summary> AT Tax Identification Number. </summary>
        public static PiiCategory AtTaxIdentificationNumber { get; } = new PiiCategory(AtTaxIdentificationNumberValue);
        /// <summary> AT Value Added Tax Number. </summary>
        public static PiiCategory AtValueAddedTaxNumber { get; } = new PiiCategory(AtValueAddedTaxNumberValue);
        /// <summary> Azure Document DB Auth Key. </summary>
        public static PiiCategory AzureDocumentDbauthKey { get; } = new PiiCategory(AzureDocumentDbauthKeyValue);
        /// <summary> Azure IAAS Database Connection And SQL String. </summary>
        public static PiiCategory AzureIaasDatabaseConnectionAndSqlString { get; } = new PiiCategory(AzureIaasDatabaseConnectionAndSqlStringValue);
        /// <summary> Azure IoT Connection String. </summary>
        public static PiiCategory AzureIoTConnectionString { get; } = new PiiCategory(AzureIoTConnectionStringValue);
        /// <summary> Azure Publish Setting Password. </summary>
        public static PiiCategory AzurePublishSettingPassword { get; } = new PiiCategory(AzurePublishSettingPasswordValue);
        /// <summary> Azure Redis Cache String. </summary>
        public static PiiCategory AzureRedisCacheString { get; } = new PiiCategory(AzureRedisCacheStringValue);
        /// <summary> Azure SAS. </summary>
        public static PiiCategory AzureSas { get; } = new PiiCategory(AzureSasValue);
        /// <summary> Azure Service Bus String. </summary>
        public static PiiCategory AzureServiceBusString { get; } = new PiiCategory(AzureServiceBusStringValue);
        /// <summary> Azure Storage Account Key. </summary>
        public static PiiCategory AzureStorageAccountKey { get; } = new PiiCategory(AzureStorageAccountKeyValue);
        /// <summary> Azure Storage Account Generic. </summary>
        public static PiiCategory AzureStorageAccountGeneric { get; } = new PiiCategory(AzureStorageAccountGenericValue);
        /// <summary> BE National Number. </summary>
        public static PiiCategory BeNationalNumber { get; } = new PiiCategory(BeNationalNumberValue);
        /// <summary> BE National Number V2. </summary>
        public static PiiCategory BeNationalNumberV2 { get; } = new PiiCategory(BeNationalNumberV2Value);
        /// <summary> BE Value Added Tax Number. </summary>
        public static PiiCategory BeValueAddedTaxNumber { get; } = new PiiCategory(BeValueAddedTaxNumberValue);
        /// <summary> BR CPF Number. </summary>
        public static PiiCategory BrCpfNumber { get; } = new PiiCategory(BrCpfNumberValue);
        /// <summary> BR Legal Entity Number. </summary>
        public static PiiCategory BrLegalEntityNumber { get; } = new PiiCategory(BrLegalEntityNumberValue);
        /// <summary> BR National ID RG. </summary>
        public static PiiCategory BrNationalIdRg { get; } = new PiiCategory(BrNationalIdRgValue);
        /// <summary> BG Uniform Civil Number. </summary>
        public static PiiCategory BgUniformCivilNumber { get; } = new PiiCategory(BgUniformCivilNumberValue);
        /// <summary> CA Bank Account Number. </summary>
        public static PiiCategory CaBankAccountNumber { get; } = new PiiCategory(CaBankAccountNumberValue);
        /// <summary> CA Driver's License Number. </summary>
        public static PiiCategory CaDriversLicenseNumber { get; } = new PiiCategory(CaDriversLicenseNumberValue);
        /// <summary> CA Health Service Number. </summary>
        public static PiiCategory CaHealthServiceNumber { get; } = new PiiCategory(CaHealthServiceNumberValue);
        /// <summary> CA Passport Number. </summary>
        public static PiiCategory CaPassportNumber { get; } = new PiiCategory(CaPassportNumberValue);
        /// <summary> CA Personal Health Identification. </summary>
        public static PiiCategory CaPersonalHealthIdentification { get; } = new PiiCategory(CaPersonalHealthIdentificationValue);
        /// <summary> CA Social Insurance Number. </summary>
        public static PiiCategory CaSocialInsuranceNumber { get; } = new PiiCategory(CaSocialInsuranceNumberValue);
        /// <summary> CL Identity Card Number. </summary>
        public static PiiCategory ClIdentityCardNumber { get; } = new PiiCategory(ClIdentityCardNumberValue);
        /// <summary> CN Resident Identity Card Number. </summary>
        public static PiiCategory CnResidentIdentityCardNumber { get; } = new PiiCategory(CnResidentIdentityCardNumberValue);
        /// <summary> Credit Card Number. </summary>
        public static PiiCategory CreditCardNumber { get; } = new PiiCategory(CreditCardNumberValue);
        /// <summary> HR Identity Card Number. </summary>
        public static PiiCategory HrIdentityCardNumber { get; } = new PiiCategory(HrIdentityCardNumberValue);
        /// <summary> HR National ID Number. </summary>
        public static PiiCategory HrNationalIdNumber { get; } = new PiiCategory(HrNationalIdNumberValue);
        /// <summary> HR Personal Identification Number. </summary>
        public static PiiCategory HrPersonalIdentificationNumber { get; } = new PiiCategory(HrPersonalIdentificationNumberValue);
        /// <summary> HR Personal Identification OIB Number V2. </summary>
        public static PiiCategory HrPersonalIdentificationOIBNumberV2 { get; } = new PiiCategory(HrPersonalIdentificationOIBNumberV2Value);
        /// <summary> CY Identity Card. </summary>
        public static PiiCategory CyIdentityCard { get; } = new PiiCategory(CyIdentityCardValue);
        /// <summary> CY Tax Identification Number. </summary>
        public static PiiCategory CyTaxIdentificationNumber { get; } = new PiiCategory(CyTaxIdentificationNumberValue);
        /// <summary> CZ Personal Identity Number. </summary>
        public static PiiCategory CzPersonalIdentityNumber { get; } = new PiiCategory(CzPersonalIdentityNumberValue);
        /// <summary> CZ Personal Identity V2. </summary>
        public static PiiCategory CzPersonalIdentityV2 { get; } = new PiiCategory(CzPersonalIdentityV2Value);
        /// <summary> DK Personal Identification Number. </summary>
        public static PiiCategory DkPersonalIdentificationNumber { get; } = new PiiCategory(DkPersonalIdentificationNumberValue);
        /// <summary> DK Personal Identification V2. </summary>
        public static PiiCategory DkPersonalIdentificationV2 { get; } = new PiiCategory(DkPersonalIdentificationV2Value);
        /// <summary> Drug Enforcement Agency Number. </summary>
        public static PiiCategory DrugEnforcementAgencyNumber { get; } = new PiiCategory(DrugEnforcementAgencyNumberValue);
        /// <summary> EE Personal Identification Code. </summary>
        public static PiiCategory EePersonalIdentificationCode { get; } = new PiiCategory(EePersonalIdentificationCodeValue);
        /// <summary> EU Debit Card Number. </summary>
        public static PiiCategory EuDebitCardNumber { get; } = new PiiCategory(EuDebitCardNumberValue);
        /// <summary> EU Driver's License Number. </summary>
        public static PiiCategory EuDriversLicenseNumber { get; } = new PiiCategory(EuDriversLicenseNumberValue);
        /// <summary> EU GPS Coordinates. </summary>
        public static PiiCategory EuGpsCoordinates { get; } = new PiiCategory(EuGpsCoordinatesValue);
        /// <summary> EU National Identification Number. </summary>
        public static PiiCategory EuNationalIdentificationNumber { get; } = new PiiCategory(EuNationalIdentificationNumberValue);
        /// <summary> EU Passport Number. </summary>
        public static PiiCategory EuPassportNumber { get; } = new PiiCategory(EuPassportNumberValue);
        /// <summary> EU Social Security Number. </summary>
        public static PiiCategory EuSocialSecurityNumber { get; } = new PiiCategory(EuSocialSecurityNumberValue);
        /// <summary> EU Tax Identification Number. </summary>
        public static PiiCategory EuTaxIdentificationNumber { get; } = new PiiCategory(EuTaxIdentificationNumberValue);
        /// <summary> FI European Health Number. </summary>
        public static PiiCategory FiEuropeanHealthNumber { get; } = new PiiCategory(FiEuropeanHealthNumberValue);
        /// <summary> FI National ID. </summary>
        public static PiiCategory FiNationalId { get; } = new PiiCategory(FiNationalIdValue);
        /// <summary> FI National ID V2. </summary>
        public static PiiCategory FiNationalIdV2 { get; } = new PiiCategory(FiNationalIdV2Value);
        /// <summary> FI Passport Number. </summary>
        public static PiiCategory FiPassportNumber { get; } = new PiiCategory(FiPassportNumberValue);
        /// <summary> FR Driver's License Number. </summary>
        public static PiiCategory FrDriversLicenseNumber { get; } = new PiiCategory(FrDriversLicenseNumberValue);
        /// <summary> FR Health Insurance Number. </summary>
        public static PiiCategory FrHealthInsuranceNumber { get; } = new PiiCategory(FrHealthInsuranceNumberValue);
        /// <summary> FR National ID. </summary>
        public static PiiCategory FrNationalId { get; } = new PiiCategory(FrNationalIdValue);
        /// <summary> FR Passport Number. </summary>
        public static PiiCategory FrPassportNumber { get; } = new PiiCategory(FrPassportNumberValue);
        /// <summary> FR Social Security Number. </summary>
        public static PiiCategory FrSocialSecurityNumber { get; } = new PiiCategory(FrSocialSecurityNumberValue);
        /// <summary> FR Tax Identification Number. </summary>
        public static PiiCategory FrTaxIdentificationNumber { get; } = new PiiCategory(FrTaxIdentificationNumberValue);
        /// <summary> FR Value Added Tax Number. </summary>
        public static PiiCategory FrValueAddedTaxNumber { get; } = new PiiCategory(FrValueAddedTaxNumberValue);
        /// <summary> DE Driver's License Number. </summary>
        public static PiiCategory DeDriversLicenseNumber { get; } = new PiiCategory(DeDriversLicenseNumberValue);
        /// <summary> DE Passport Number. </summary>
        public static PiiCategory DePassportNumber { get; } = new PiiCategory(DePassportNumberValue);
        /// <summary> DE Identity Card Number. </summary>
        public static PiiCategory DeIdentityCardNumber { get; } = new PiiCategory(DeIdentityCardNumberValue);
        /// <summary> DE Tax Identification Number. </summary>
        public static PiiCategory DeTaxIdentificationNumber { get; } = new PiiCategory(DeTaxIdentificationNumberValue);
        /// <summary> DE Value Added Number. </summary>
        public static PiiCategory DeValueAddedNumber { get; } = new PiiCategory(DeValueAddedNumberValue);
        /// <summary> GR National ID Card. </summary>
        public static PiiCategory GrNationalIdCard { get; } = new PiiCategory(GrNationalIdCardValue);
        /// <summary> GR National ID V2. </summary>
        public static PiiCategory GrNationalIdV2 { get; } = new PiiCategory(GrNationalIdV2Value);
        /// <summary> GR Tax Identification Number. </summary>
        public static PiiCategory GrTaxIdentificationNumber { get; } = new PiiCategory(GrTaxIdentificationNumberValue);
        /// <summary> HK Identity Card Number. </summary>
        public static PiiCategory HkIdentityCardNumber { get; } = new PiiCategory(HkIdentityCardNumberValue);
        /// <summary> HU Value Added Number. </summary>
        public static PiiCategory HuValueAddedNumber { get; } = new PiiCategory(HuValueAddedNumberValue);
        /// <summary> HU Personal Identification Number. </summary>
        public static PiiCategory HuPersonalIdentificationNumber { get; } = new PiiCategory(HuPersonalIdentificationNumberValue);
        /// <summary> HU Tax Identification Number. </summary>
        public static PiiCategory HuTaxIdentificationNumber { get; } = new PiiCategory(HuTaxIdentificationNumberValue);
        /// <summary> IN Permanent Account. </summary>
        public static PiiCategory InPermanentAccount { get; } = new PiiCategory(InPermanentAccountValue);
        /// <summary> IN Unique Identification Number. </summary>
        public static PiiCategory InUniqueIdentificationNumber { get; } = new PiiCategory(InUniqueIdentificationNumberValue);
        /// <summary> ID Identity Card Number. </summary>
        public static PiiCategory IdIdentityCardNumber { get; } = new PiiCategory(IdIdentityCardNumberValue);
        /// <summary> International Banking Account Number. </summary>
        public static PiiCategory InternationalBankingAccountNumber { get; } = new PiiCategory(InternationalBankingAccountNumberValue);
        /// <summary> IE Personal Public Service Number. </summary>
        public static PiiCategory IePersonalPublicServiceNumber { get; } = new PiiCategory(IePersonalPublicServiceNumberValue);
        /// <summary> IE Personal Public Service Number V2. </summary>
        public static PiiCategory IePersonalPublicServiceNumberV2 { get; } = new PiiCategory(IePersonalPublicServiceNumberV2Value);
        /// <summary> IL Bank Account Number. </summary>
        public static PiiCategory IlBankAccountNumber { get; } = new PiiCategory(IlBankAccountNumberValue);
        /// <summary> IL National ID. </summary>
        public static PiiCategory IlNationalId { get; } = new PiiCategory(IlNationalIdValue);
        /// <summary> IT Driver's License Number. </summary>
        public static PiiCategory ItDriversLicenseNumber { get; } = new PiiCategory(ItDriversLicenseNumberValue);
        /// <summary> IT Fiscal Code. </summary>
        public static PiiCategory ItFiscalCode { get; } = new PiiCategory(ItFiscalCodeValue);
        /// <summary> IT Value Added Tax Number. </summary>
        public static PiiCategory ItValueAddedTaxNumber { get; } = new PiiCategory(ItValueAddedTaxNumberValue);
        /// <summary> JP Bank Account Number. </summary>
        public static PiiCategory JpBankAccountNumber { get; } = new PiiCategory(JpBankAccountNumberValue);
        /// <summary> JP Driver's License Number. </summary>
        public static PiiCategory JpDriversLicenseNumber { get; } = new PiiCategory(JpDriversLicenseNumberValue);
        /// <summary> JP Passport Number. </summary>
        public static PiiCategory JpPassportNumber { get; } = new PiiCategory(JpPassportNumberValue);
        /// <summary> JP Resident Registration Number. </summary>
        public static PiiCategory JpResidentRegistrationNumber { get; } = new PiiCategory(JpResidentRegistrationNumberValue);
        /// <summary> JP Social Insurance Number. </summary>
        public static PiiCategory JpSocialInsuranceNumber { get; } = new PiiCategory(JpSocialInsuranceNumberValue);
        /// <summary> JP My Number Corporate. </summary>
        public static PiiCategory JpMyNumberCorporate { get; } = new PiiCategory(JpMyNumberCorporateValue);
        /// <summary> JP My Number Personal. </summary>
        public static PiiCategory JpMyNumberPersonal { get; } = new PiiCategory(JpMyNumberPersonalValue);
        /// <summary> JP Residence Card Number. </summary>
        public static PiiCategory JpResidenceCardNumber { get; } = new PiiCategory(JpResidenceCardNumberValue);
        /// <summary> LV Personal Code. </summary>
        public static PiiCategory LvPersonalCode { get; } = new PiiCategory(LvPersonalCodeValue);
        /// <summary> LT Personal Code. </summary>
        public static PiiCategory LtPersonalCode { get; } = new PiiCategory(LtPersonalCodeValue);
        /// <summary> LU National Identification Number Natural. </summary>
        public static PiiCategory LuNationalIdentificationNumberNatural { get; } = new PiiCategory(LuNationalIdentificationNumberNaturalValue);
        /// <summary> LU National Identification Number Non Natural. </summary>
        public static PiiCategory LuNationalIdentificationNumberNonNatural { get; } = new PiiCategory(LuNationalIdentificationNumberNonNaturalValue);
        /// <summary> MY Identity Card Number. </summary>
        public static PiiCategory MyIdentityCardNumber { get; } = new PiiCategory(MyIdentityCardNumberValue);
        /// <summary> MT Identity Card Number. </summary>
        public static PiiCategory MtIdentityCardNumber { get; } = new PiiCategory(MtIdentityCardNumberValue);
        /// <summary> MT Tax ID Number. </summary>
        public static PiiCategory MtTaxIdNumber { get; } = new PiiCategory(MtTaxIdNumberValue);
        /// <summary> NL Citizens Service Number. </summary>
        public static PiiCategory NlCitizensServiceNumber { get; } = new PiiCategory(NlCitizensServiceNumberValue);
        /// <summary> NL Citizens Service Number V2. </summary>
        public static PiiCategory NlCitizensServiceNumberV2 { get; } = new PiiCategory(NlCitizensServiceNumberV2Value);
        /// <summary> NL Tax Identification Number. </summary>
        public static PiiCategory NlTaxIdentificationNumber { get; } = new PiiCategory(NlTaxIdentificationNumberValue);
        /// <summary> NL Value Added Tax Number. </summary>
        public static PiiCategory NlValueAddedTaxNumber { get; } = new PiiCategory(NlValueAddedTaxNumberValue);
        /// <summary> NZ Bank Account Number. </summary>
        public static PiiCategory NzBankAccountNumber { get; } = new PiiCategory(NzBankAccountNumberValue);
        /// <summary> NZ Driver's License Number. </summary>
        public static PiiCategory NzDriversLicenseNumber { get; } = new PiiCategory(NzDriversLicenseNumberValue);
        /// <summary> NZ Inland Revenue Number. </summary>
        public static PiiCategory NzInlandRevenueNumber { get; } = new PiiCategory(NzInlandRevenueNumberValue);
        /// <summary> NZ Ministry Of Health Number. </summary>
        public static PiiCategory NzMinistryOfHealthNumber { get; } = new PiiCategory(NzMinistryOfHealthNumberValue);
        /// <summary> NZ Social Welfare Number. </summary>
        public static PiiCategory NzSocialWelfareNumber { get; } = new PiiCategory(NzSocialWelfareNumberValue);
        /// <summary> NO Identity Number. </summary>
        public static PiiCategory NoIdentityNumber { get; } = new PiiCategory(NoIdentityNumberValue);
        /// <summary> PH Unified Multi Purpose ID Number. </summary>
        public static PiiCategory PhUnifiedMultiPurposeIdNumber { get; } = new PiiCategory(PhUnifiedMultiPurposeIdNumberValue);
        /// <summary> PL Identity Card. </summary>
        public static PiiCategory PlIdentityCard { get; } = new PiiCategory(PlIdentityCardValue);
        /// <summary> PL National ID. </summary>
        public static PiiCategory PlNationalId { get; } = new PiiCategory(PlNationalIdValue);
        /// <summary> PL National ID V2. </summary>
        public static PiiCategory PlNationalIdV2 { get; } = new PiiCategory(PlNationalIdV2Value);
        /// <summary> PL Passport Number. </summary>
        public static PiiCategory PlPassportNumber { get; } = new PiiCategory(PlPassportNumberValue);
        /// <summary> PL Tax Identification Number. </summary>
        public static PiiCategory PlTaxIdentificationNumber { get; } = new PiiCategory(PlTaxIdentificationNumberValue);
        /// <summary> PL REGON Number. </summary>
        public static PiiCategory PlRegonNumber { get; } = new PiiCategory(PlRegonNumberValue);
        /// <summary> PT Citizen Card Number. </summary>
        public static PiiCategory PtCitizenCardNumber { get; } = new PiiCategory(PtCitizenCardNumberValue);
        /// <summary> PT Citizen Card Number V2. </summary>
        public static PiiCategory PtCitizenCardNumberV2 { get; } = new PiiCategory(PtCitizenCardNumberV2Value);
        /// <summary> PT Tax Identification Number. </summary>
        public static PiiCategory PtTaxIdentificationNumber { get; } = new PiiCategory(PtTaxIdentificationNumberValue);
        /// <summary> RO Personal Numerical Code. </summary>
        public static PiiCategory RoPersonalNumericalCode { get; } = new PiiCategory(RoPersonalNumericalCodeValue);
        /// <summary> RU Passport Number Domestic. </summary>
        public static PiiCategory RuPassportNumberDomestic { get; } = new PiiCategory(RuPassportNumberDomesticValue);
        /// <summary> RU Passport Number International. </summary>
        public static PiiCategory RuPassportNumberInternational { get; } = new PiiCategory(RuPassportNumberInternationalValue);
        /// <summary> SA National ID. </summary>
        public static PiiCategory SaNationalId { get; } = new PiiCategory(SaNationalIdValue);
        /// <summary> SG National Registration Identity Card Number. </summary>
        public static PiiCategory SgNationalRegistrationIdentityCardNumber { get; } = new PiiCategory(SgNationalRegistrationIdentityCardNumberValue);
        /// <summary> SK Personal Number. </summary>
        public static PiiCategory SkPersonalNumber { get; } = new PiiCategory(SkPersonalNumberValue);
        /// <summary> SI Tax Identification Number. </summary>
        public static PiiCategory SiTaxIdentificationNumber { get; } = new PiiCategory(SiTaxIdentificationNumberValue);
        /// <summary> SI Unique Master Citizen Number. </summary>
        public static PiiCategory SiUniqueMasterCitizenNumber { get; } = new PiiCategory(SiUniqueMasterCitizenNumberValue);
        /// <summary> ZA Identification Number. </summary>
        public static PiiCategory ZaIdentificationNumber { get; } = new PiiCategory(ZaIdentificationNumberValue);
        /// <summary> KR Resident Registration Number. </summary>
        public static PiiCategory KrResidentRegistrationNumber { get; } = new PiiCategory(KrResidentRegistrationNumberValue);
        /// <summary> ES DNI. </summary>
        public static PiiCategory EsDni { get; } = new PiiCategory(EsDniValue);
        /// <summary> ES Social Security Number. </summary>
        public static PiiCategory EsSocialSecurityNumber { get; } = new PiiCategory(EsSocialSecurityNumberValue);
        /// <summary> ES Tax Identification Number. </summary>
        public static PiiCategory EsTaxIdentificationNumber { get; } = new PiiCategory(EsTaxIdentificationNumberValue);
        /// <summary> SQL Server Connection String. </summary>
        public static PiiCategory SqlServerConnectionString { get; } = new PiiCategory(SqlServerConnectionStringValue);
        /// <summary> SE National ID. </summary>
        public static PiiCategory SeNationalId { get; } = new PiiCategory(SeNationalIdValue);
        /// <summary> SE National ID V2. </summary>
        public static PiiCategory SeNationalIdV2 { get; } = new PiiCategory(SeNationalIdV2Value);
        /// <summary> SE Passport Number. </summary>
        public static PiiCategory SePassportNumber { get; } = new PiiCategory(SePassportNumberValue);
        /// <summary> SE Tax Identification Number. </summary>
        public static PiiCategory SeTaxIdentificationNumber { get; } = new PiiCategory(SeTaxIdentificationNumberValue);
        /// <summary> SWIFT Code. </summary>
        public static PiiCategory SwiftCode { get; } = new PiiCategory(SwiftCodeValue);
        /// <summary> CH Social Security Number. </summary>
        public static PiiCategory ChSocialSecurityNumber { get; } = new PiiCategory(ChSocialSecurityNumberValue);
        /// <summary> TW National ID. </summary>
        public static PiiCategory TwNationalId { get; } = new PiiCategory(TwNationalIdValue);
        /// <summary> TW Passport Number. </summary>
        public static PiiCategory TwPassportNumber { get; } = new PiiCategory(TwPassportNumberValue);
        /// <summary> TW Resident Certificate. </summary>
        public static PiiCategory TwResidentCertificate { get; } = new PiiCategory(TwResidentCertificateValue);
        /// <summary> TH Population Identification Code. </summary>
        public static PiiCategory ThPopulationIdentificationCode { get; } = new PiiCategory(ThPopulationIdentificationCodeValue);
        /// <summary> TR National Identification Number. </summary>
        public static PiiCategory TrNationalIdentificationNumber { get; } = new PiiCategory(TrNationalIdentificationNumberValue);
        /// <summary> UK Driver's License Number. </summary>
        public static PiiCategory UkDriversLicenseNumber { get; } = new PiiCategory(UkDriversLicenseNumberValue);
        /// <summary> UK Electoral Roll Number. </summary>
        public static PiiCategory UkElectoralRollNumber { get; } = new PiiCategory(UkElectoralRollNumberValue);
        /// <summary> UK National Health Number. </summary>
        public static PiiCategory UkNationalHealthNumber { get; } = new PiiCategory(UkNationalHealthNumberValue);
        /// <summary> UK National Insurance Number. </summary>
        public static PiiCategory UkNationalInsuranceNumber { get; } = new PiiCategory(UkNationalInsuranceNumberValue);
        /// <summary> UK Unique Taxpayer Number. </summary>
        public static PiiCategory UkUniqueTaxpayerNumber { get; } = new PiiCategory(UkUniqueTaxpayerNumberValue);
        /// <summary> US UK Passport Number. </summary>
        public static PiiCategory UsUkPassportNumber { get; } = new PiiCategory(UsUkPassportNumberValue);
        /// <summary> US Bank Account Number. </summary>
        public static PiiCategory UsBankAccountNumber { get; } = new PiiCategory(UsBankAccountNumberValue);
        /// <summary> US Driver's License Number. </summary>
        public static PiiCategory UsDriversLicenseNumber { get; } = new PiiCategory(UsDriversLicenseNumberValue);
        /// <summary> US Individual Taxpayer Identification. </summary>
        public static PiiCategory UsIndividualTaxpayerIdentification { get; } = new PiiCategory(UsIndividualTaxpayerIdentificationValue);
        /// <summary> US Social Security Number. </summary>
        public static PiiCategory UsSocialSecurityNumber { get; } = new PiiCategory(UsSocialSecurityNumberValue);
        /// <summary> UA Passport Number Domestic. </summary>
        public static PiiCategory UaPassportNumberDomestic { get; } = new PiiCategory(UaPassportNumberDomesticValue);
        /// <summary> UA Passport Number International. </summary>
        public static PiiCategory UaPassportNumberInternational { get; } = new PiiCategory(UaPassportNumberInternationalValue);
        /// <summary> Organization. </summary>
        public static PiiCategory Organization { get; } = new PiiCategory(OrganizationValue);
        /// <summary> Email. </summary>
        public static PiiCategory Email { get; } = new PiiCategory(EmailValue);
        /// <summary> URL. </summary>
        public static PiiCategory URL { get; } = new PiiCategory(URLValue);
        /// <summary> Age. </summary>
        public static PiiCategory Age { get; } = new PiiCategory(AgeValue);
        /// <summary> Phone Number. </summary>
        public static PiiCategory PhoneNumber { get; } = new PiiCategory(PhoneNumberValue);
        /// <summary> IP Address. </summary>
        public static PiiCategory IPAddress { get; } = new PiiCategory(IPAddressValue);
        /// <summary> Date. </summary>
        public static PiiCategory Date { get; } = new PiiCategory(DateValue);
        /// <summary> Person. </summary>
        public static PiiCategory Person { get; } = new PiiCategory(PersonValue);
        /// <summary> Address. </summary>
        public static PiiCategory Address { get; } = new PiiCategory(AddressValue);
        /// <summary> All PII categories. </summary>
        public static PiiCategory All { get; } = new PiiCategory(AllValue);
        /// <summary> Default PII categories for the language. </summary>
        public static PiiCategory Default { get; } = new PiiCategory(DefaultValue);
        /// <summary> Determines if two <see cref="PiiCategory"/> values are the same. </summary>
        public static bool operator ==(PiiCategory left, PiiCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PiiCategory"/> values are not the same. </summary>
        public static bool operator !=(PiiCategory left, PiiCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PiiCategory"/>. </summary>
        public static implicit operator PiiCategory(string value) => new PiiCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PiiCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PiiCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
