// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> (Optional) describes the PII categories to return. </summary>
    public readonly partial struct PiiCategoriesExclude : IEquatable<PiiCategoriesExclude>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PiiCategoriesExclude"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PiiCategoriesExclude(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AbaRoutingNumberValue = "ABARoutingNumber";
        private const string ArNationalIdentityNumberValue = "ARNationalIdentityNumber";
        private const string AuBankAccountNumberValue = "AUBankAccountNumber";
        private const string AuDriversLicenseNumberValue = "AUDriversLicenseNumber";
        private const string AuMedicalAccountNumberValue = "AUMedicalAccountNumber";
        private const string AuPassportNumberValue = "AUPassportNumber";
        private const string AuTaxFileNumberValue = "AUTaxFileNumber";
        private const string AuBusinessNumberValue = "AUBusinessNumber";
        private const string AuCompanyNumberValue = "AUCompanyNumber";
        private const string AtIdentityCardValue = "ATIdentityCard";
        private const string AtTaxIdentificationNumberValue = "ATTaxIdentificationNumber";
        private const string AtValueAddedTaxNumberValue = "ATValueAddedTaxNumber";
        private const string AzureDocumentDbauthKeyValue = "AzureDocumentDBAuthKey";
        private const string AzureIaasDatabaseConnectionAndSqlStringValue = "AzureIAASDatabaseConnectionAndSQLString";
        private const string AzureIoTConnectionStringValue = "AzureIoTConnectionString";
        private const string AzurePublishSettingPasswordValue = "AzurePublishSettingPassword";
        private const string AzureRedisCacheStringValue = "AzureRedisCacheString";
        private const string AzureSasValue = "AzureSAS";
        private const string AzureServiceBusStringValue = "AzureServiceBusString";
        private const string AzureStorageAccountKeyValue = "AzureStorageAccountKey";
        private const string AzureStorageAccountGenericValue = "AzureStorageAccountGeneric";
        private const string BeNationalNumberValue = "BENationalNumber";
        private const string BeNationalNumberV2Value = "BENationalNumberV2";
        private const string BeValueAddedTaxNumberValue = "BEValueAddedTaxNumber";
        private const string BrCpfNumberValue = "BRCPFNumber";
        private const string BrLegalEntityNumberValue = "BRLegalEntityNumber";
        private const string BrNationalIdRgValue = "BRNationalIDRG";
        private const string BgUniformCivilNumberValue = "BGUniformCivilNumber";
        private const string CaBankAccountNumberValue = "CABankAccountNumber";
        private const string CaDriversLicenseNumberValue = "CADriversLicenseNumber";
        private const string CaHealthServiceNumberValue = "CAHealthServiceNumber";
        private const string CaPassportNumberValue = "CAPassportNumber";
        private const string CaPersonalHealthIdentificationValue = "CAPersonalHealthIdentification";
        private const string CaSocialInsuranceNumberValue = "CASocialInsuranceNumber";
        private const string ClIdentityCardNumberValue = "CLIdentityCardNumber";
        private const string CnResidentIdentityCardNumberValue = "CNResidentIdentityCardNumber";
        private const string CreditCardNumberValue = "CreditCardNumber";
        private const string HrIdentityCardNumberValue = "HRIdentityCardNumber";
        private const string HrNationalIdNumberValue = "HRNationalIDNumber";
        private const string HrPersonalIdentificationNumberValue = "HRPersonalIdentificationNumber";
        private const string HrPersonalIdentificationOIBNumberV2Value = "HRPersonalIdentificationOIBNumberV2";
        private const string CyIdentityCardValue = "CYIdentityCard";
        private const string CyTaxIdentificationNumberValue = "CYTaxIdentificationNumber";
        private const string CzPersonalIdentityNumberValue = "CZPersonalIdentityNumber";
        private const string CzPersonalIdentityV2Value = "CZPersonalIdentityV2";
        private const string DkPersonalIdentificationNumberValue = "DKPersonalIdentificationNumber";
        private const string DkPersonalIdentificationV2Value = "DKPersonalIdentificationV2";
        private const string DrugEnforcementAgencyNumberValue = "DrugEnforcementAgencyNumber";
        private const string EePersonalIdentificationCodeValue = "EEPersonalIdentificationCode";
        private const string EuDebitCardNumberValue = "EUDebitCardNumber";
        private const string EuDriversLicenseNumberValue = "EUDriversLicenseNumber";
        private const string EuGpsCoordinatesValue = "EUGPSCoordinates";
        private const string EuNationalIdentificationNumberValue = "EUNationalIdentificationNumber";
        private const string EuPassportNumberValue = "EUPassportNumber";
        private const string EuSocialSecurityNumberValue = "EUSocialSecurityNumber";
        private const string EuTaxIdentificationNumberValue = "EUTaxIdentificationNumber";
        private const string FiEuropeanHealthNumberValue = "FIEuropeanHealthNumber";
        private const string FiNationalIdValue = "FINationalID";
        private const string FiNationalIdV2Value = "FINationalIDV2";
        private const string FiPassportNumberValue = "FIPassportNumber";
        private const string FrDriversLicenseNumberValue = "FRDriversLicenseNumber";
        private const string FrHealthInsuranceNumberValue = "FRHealthInsuranceNumber";
        private const string FrNationalIdValue = "FRNationalID";
        private const string FrPassportNumberValue = "FRPassportNumber";
        private const string FrSocialSecurityNumberValue = "FRSocialSecurityNumber";
        private const string FrTaxIdentificationNumberValue = "FRTaxIdentificationNumber";
        private const string FrValueAddedTaxNumberValue = "FRValueAddedTaxNumber";
        private const string DeDriversLicenseNumberValue = "DEDriversLicenseNumber";
        private const string DePassportNumberValue = "DEPassportNumber";
        private const string DeIdentityCardNumberValue = "DEIdentityCardNumber";
        private const string DeTaxIdentificationNumberValue = "DETaxIdentificationNumber";
        private const string DeValueAddedNumberValue = "DEValueAddedNumber";
        private const string GrNationalIdCardValue = "GRNationalIDCard";
        private const string GrNationalIdV2Value = "GRNationalIDV2";
        private const string GrTaxIdentificationNumberValue = "GRTaxIdentificationNumber";
        private const string HkIdentityCardNumberValue = "HKIdentityCardNumber";
        private const string HuValueAddedNumberValue = "HUValueAddedNumber";
        private const string HuPersonalIdentificationNumberValue = "HUPersonalIdentificationNumber";
        private const string HuTaxIdentificationNumberValue = "HUTaxIdentificationNumber";
        private const string InPermanentAccountValue = "INPermanentAccount";
        private const string InUniqueIdentificationNumberValue = "INUniqueIdentificationNumber";
        private const string IdIdentityCardNumberValue = "IDIdentityCardNumber";
        private const string InternationalBankingAccountNumberValue = "InternationalBankingAccountNumber";
        private const string IePersonalPublicServiceNumberValue = "IEPersonalPublicServiceNumber";
        private const string IePersonalPublicServiceNumberV2Value = "IEPersonalPublicServiceNumberV2";
        private const string IlBankAccountNumberValue = "ILBankAccountNumber";
        private const string IlNationalIdValue = "ILNationalID";
        private const string ItDriversLicenseNumberValue = "ITDriversLicenseNumber";
        private const string ItFiscalCodeValue = "ITFiscalCode";
        private const string ItValueAddedTaxNumberValue = "ITValueAddedTaxNumber";
        private const string JpBankAccountNumberValue = "JPBankAccountNumber";
        private const string JpDriversLicenseNumberValue = "JPDriversLicenseNumber";
        private const string JpPassportNumberValue = "JPPassportNumber";
        private const string JpResidentRegistrationNumberValue = "JPResidentRegistrationNumber";
        private const string JpSocialInsuranceNumberValue = "JPSocialInsuranceNumber";
        private const string JpMyNumberCorporateValue = "JPMyNumberCorporate";
        private const string JpMyNumberPersonalValue = "JPMyNumberPersonal";
        private const string JpResidenceCardNumberValue = "JPResidenceCardNumber";
        private const string LvPersonalCodeValue = "LVPersonalCode";
        private const string LtPersonalCodeValue = "LTPersonalCode";
        private const string LuNationalIdentificationNumberNaturalValue = "LUNationalIdentificationNumberNatural";
        private const string LuNationalIdentificationNumberNonNaturalValue = "LUNationalIdentificationNumberNonNatural";
        private const string MyIdentityCardNumberValue = "MYIdentityCardNumber";
        private const string MtIdentityCardNumberValue = "MTIdentityCardNumber";
        private const string MtTaxIdNumberValue = "MTTaxIDNumber";
        private const string NlCitizensServiceNumberValue = "NLCitizensServiceNumber";
        private const string NlCitizensServiceNumberV2Value = "NLCitizensServiceNumberV2";
        private const string NlTaxIdentificationNumberValue = "NLTaxIdentificationNumber";
        private const string NlValueAddedTaxNumberValue = "NLValueAddedTaxNumber";
        private const string NzBankAccountNumberValue = "NZBankAccountNumber";
        private const string NzDriversLicenseNumberValue = "NZDriversLicenseNumber";
        private const string NzInlandRevenueNumberValue = "NZInlandRevenueNumber";
        private const string NzMinistryOfHealthNumberValue = "NZMinistryOfHealthNumber";
        private const string NzSocialWelfareNumberValue = "NZSocialWelfareNumber";
        private const string NoIdentityNumberValue = "NOIdentityNumber";
        private const string PhUnifiedMultiPurposeIdNumberValue = "PHUnifiedMultiPurposeIDNumber";
        private const string PlIdentityCardValue = "PLIdentityCard";
        private const string PlNationalIdValue = "PLNationalID";
        private const string PlNationalIdV2Value = "PLNationalIDV2";
        private const string PlPassportNumberValue = "PLPassportNumber";
        private const string PlTaxIdentificationNumberValue = "PLTaxIdentificationNumber";
        private const string PlRegonNumberValue = "PLREGONNumber";
        private const string PtCitizenCardNumberValue = "PTCitizenCardNumber";
        private const string PtCitizenCardNumberV2Value = "PTCitizenCardNumberV2";
        private const string PtTaxIdentificationNumberValue = "PTTaxIdentificationNumber";
        private const string RoPersonalNumericalCodeValue = "ROPersonalNumericalCode";
        private const string RuPassportNumberDomesticValue = "RUPassportNumberDomestic";
        private const string RuPassportNumberInternationalValue = "RUPassportNumberInternational";
        private const string SaNationalIdValue = "SANationalID";
        private const string SgNationalRegistrationIdentityCardNumberValue = "SGNationalRegistrationIdentityCardNumber";
        private const string SkPersonalNumberValue = "SKPersonalNumber";
        private const string SiTaxIdentificationNumberValue = "SITaxIdentificationNumber";
        private const string SiUniqueMasterCitizenNumberValue = "SIUniqueMasterCitizenNumber";
        private const string ZaIdentificationNumberValue = "ZAIdentificationNumber";
        private const string KrResidentRegistrationNumberValue = "KRResidentRegistrationNumber";
        private const string EsDniValue = "ESDNI";
        private const string EsSocialSecurityNumberValue = "ESSocialSecurityNumber";
        private const string EsTaxIdentificationNumberValue = "ESTaxIdentificationNumber";
        private const string SqlServerConnectionStringValue = "SQLServerConnectionString";
        private const string SeNationalIdValue = "SENationalID";
        private const string SeNationalIdV2Value = "SENationalIDV2";
        private const string SePassportNumberValue = "SEPassportNumber";
        private const string SeTaxIdentificationNumberValue = "SETaxIdentificationNumber";
        private const string SwiftCodeValue = "SWIFTCode";
        private const string ChSocialSecurityNumberValue = "CHSocialSecurityNumber";
        private const string TwNationalIdValue = "TWNationalID";
        private const string TwPassportNumberValue = "TWPassportNumber";
        private const string TwResidentCertificateValue = "TWResidentCertificate";
        private const string ThPopulationIdentificationCodeValue = "THPopulationIdentificationCode";
        private const string TrNationalIdentificationNumberValue = "TRNationalIdentificationNumber";
        private const string UkDriversLicenseNumberValue = "UKDriversLicenseNumber";
        private const string UkElectoralRollNumberValue = "UKElectoralRollNumber";
        private const string UkNationalHealthNumberValue = "UKNationalHealthNumber";
        private const string UkNationalInsuranceNumberValue = "UKNationalInsuranceNumber";
        private const string UkUniqueTaxpayerNumberValue = "UKUniqueTaxpayerNumber";
        private const string UsUkPassportNumberValue = "USUKPassportNumber";
        private const string UsBankAccountNumberValue = "USBankAccountNumber";
        private const string UsDriversLicenseNumberValue = "USDriversLicenseNumber";
        private const string UsIndividualTaxpayerIdentificationValue = "USIndividualTaxpayerIdentification";
        private const string UsSocialSecurityNumberValue = "USSocialSecurityNumber";
        private const string UaPassportNumberDomesticValue = "UAPassportNumberDomestic";
        private const string UaPassportNumberInternationalValue = "UAPassportNumberInternational";
        private const string OrganizationValue = "Organization";
        private const string EmailValue = "Email";
        private const string URLValue = "URL";
        private const string AgeValue = "Age";
        private const string PhoneNumberValue = "PhoneNumber";
        private const string IPAddressValue = "IPAddress";
        private const string DateValue = "Date";
        private const string PersonValue = "Person";
        private const string AddressValue = "Address";

        /// <summary> ABA Routing number. </summary>
        public static PiiCategoriesExclude AbaRoutingNumber { get; } = new PiiCategoriesExclude(AbaRoutingNumberValue);
        /// <summary> AR National Identity Number. </summary>
        public static PiiCategoriesExclude ArNationalIdentityNumber { get; } = new PiiCategoriesExclude(ArNationalIdentityNumberValue);
        /// <summary> AT Identity Card. </summary>
        public static PiiCategoriesExclude AuBankAccountNumber { get; } = new PiiCategoriesExclude(AuBankAccountNumberValue);
        /// <summary> AU Driver's License Number. </summary>
        public static PiiCategoriesExclude AuDriversLicenseNumber { get; } = new PiiCategoriesExclude(AuDriversLicenseNumberValue);
        /// <summary> AU Medical Account Number. </summary>
        public static PiiCategoriesExclude AuMedicalAccountNumber { get; } = new PiiCategoriesExclude(AuMedicalAccountNumberValue);
        /// <summary> AU Passport Number. </summary>
        public static PiiCategoriesExclude AuPassportNumber { get; } = new PiiCategoriesExclude(AuPassportNumberValue);
        /// <summary> AU Tax File Number. </summary>
        public static PiiCategoriesExclude AuTaxFileNumber { get; } = new PiiCategoriesExclude(AuTaxFileNumberValue);
        /// <summary> AU Business Number. </summary>
        public static PiiCategoriesExclude AuBusinessNumber { get; } = new PiiCategoriesExclude(AuBusinessNumberValue);
        /// <summary> AU Company Number. </summary>
        public static PiiCategoriesExclude AuCompanyNumber { get; } = new PiiCategoriesExclude(AuCompanyNumberValue);
        /// <summary> AT Identity Card. </summary>
        public static PiiCategoriesExclude AtIdentityCard { get; } = new PiiCategoriesExclude(AtIdentityCardValue);
        /// <summary> AT Tax Identification Number. </summary>
        public static PiiCategoriesExclude AtTaxIdentificationNumber { get; } = new PiiCategoriesExclude(AtTaxIdentificationNumberValue);
        /// <summary> AT Value Added Tax Number. </summary>
        public static PiiCategoriesExclude AtValueAddedTaxNumber { get; } = new PiiCategoriesExclude(AtValueAddedTaxNumberValue);
        /// <summary> Azure Document DB Auth Key. </summary>
        public static PiiCategoriesExclude AzureDocumentDbauthKey { get; } = new PiiCategoriesExclude(AzureDocumentDbauthKeyValue);
        /// <summary> Azure IAAS Database Connection And SQL String. </summary>
        public static PiiCategoriesExclude AzureIaasDatabaseConnectionAndSqlString { get; } = new PiiCategoriesExclude(AzureIaasDatabaseConnectionAndSqlStringValue);
        /// <summary> Azure IoT Connection String. </summary>
        public static PiiCategoriesExclude AzureIoTConnectionString { get; } = new PiiCategoriesExclude(AzureIoTConnectionStringValue);
        /// <summary> Azure Publish Setting Password. </summary>
        public static PiiCategoriesExclude AzurePublishSettingPassword { get; } = new PiiCategoriesExclude(AzurePublishSettingPasswordValue);
        /// <summary> Azure Redis Cache String. </summary>
        public static PiiCategoriesExclude AzureRedisCacheString { get; } = new PiiCategoriesExclude(AzureRedisCacheStringValue);
        /// <summary> Azure SAS. </summary>
        public static PiiCategoriesExclude AzureSas { get; } = new PiiCategoriesExclude(AzureSasValue);
        /// <summary> Azure Service Bus String. </summary>
        public static PiiCategoriesExclude AzureServiceBusString { get; } = new PiiCategoriesExclude(AzureServiceBusStringValue);
        /// <summary> Azure Storage Account Key. </summary>
        public static PiiCategoriesExclude AzureStorageAccountKey { get; } = new PiiCategoriesExclude(AzureStorageAccountKeyValue);
        /// <summary> Azure Storage Account Generic. </summary>
        public static PiiCategoriesExclude AzureStorageAccountGeneric { get; } = new PiiCategoriesExclude(AzureStorageAccountGenericValue);
        /// <summary> BE National Number. </summary>
        public static PiiCategoriesExclude BeNationalNumber { get; } = new PiiCategoriesExclude(BeNationalNumberValue);
        /// <summary> BE National Number V2. </summary>
        public static PiiCategoriesExclude BeNationalNumberV2 { get; } = new PiiCategoriesExclude(BeNationalNumberV2Value);
        /// <summary> BE Value Added Tax Number. </summary>
        public static PiiCategoriesExclude BeValueAddedTaxNumber { get; } = new PiiCategoriesExclude(BeValueAddedTaxNumberValue);
        /// <summary> BR CPF Number. </summary>
        public static PiiCategoriesExclude BrCpfNumber { get; } = new PiiCategoriesExclude(BrCpfNumberValue);
        /// <summary> BR Legal Entity Number. </summary>
        public static PiiCategoriesExclude BrLegalEntityNumber { get; } = new PiiCategoriesExclude(BrLegalEntityNumberValue);
        /// <summary> BR National ID RG. </summary>
        public static PiiCategoriesExclude BrNationalIdRg { get; } = new PiiCategoriesExclude(BrNationalIdRgValue);
        /// <summary> BG Uniform Civil Number. </summary>
        public static PiiCategoriesExclude BgUniformCivilNumber { get; } = new PiiCategoriesExclude(BgUniformCivilNumberValue);
        /// <summary> CA Bank Account Number. </summary>
        public static PiiCategoriesExclude CaBankAccountNumber { get; } = new PiiCategoriesExclude(CaBankAccountNumberValue);
        /// <summary> CA Driver's License Number. </summary>
        public static PiiCategoriesExclude CaDriversLicenseNumber { get; } = new PiiCategoriesExclude(CaDriversLicenseNumberValue);
        /// <summary> CA Health Service Number. </summary>
        public static PiiCategoriesExclude CaHealthServiceNumber { get; } = new PiiCategoriesExclude(CaHealthServiceNumberValue);
        /// <summary> CA Passport Number. </summary>
        public static PiiCategoriesExclude CaPassportNumber { get; } = new PiiCategoriesExclude(CaPassportNumberValue);
        /// <summary> CA Personal Health Identification. </summary>
        public static PiiCategoriesExclude CaPersonalHealthIdentification { get; } = new PiiCategoriesExclude(CaPersonalHealthIdentificationValue);
        /// <summary> CA Social Insurance Number. </summary>
        public static PiiCategoriesExclude CaSocialInsuranceNumber { get; } = new PiiCategoriesExclude(CaSocialInsuranceNumberValue);
        /// <summary> CL Identity Card Number. </summary>
        public static PiiCategoriesExclude ClIdentityCardNumber { get; } = new PiiCategoriesExclude(ClIdentityCardNumberValue);
        /// <summary> CN Resident Identity Card Number. </summary>
        public static PiiCategoriesExclude CnResidentIdentityCardNumber { get; } = new PiiCategoriesExclude(CnResidentIdentityCardNumberValue);
        /// <summary> Credit Card Number. </summary>
        public static PiiCategoriesExclude CreditCardNumber { get; } = new PiiCategoriesExclude(CreditCardNumberValue);
        /// <summary> HR Identity Card Number. </summary>
        public static PiiCategoriesExclude HrIdentityCardNumber { get; } = new PiiCategoriesExclude(HrIdentityCardNumberValue);
        /// <summary> HR National ID Number. </summary>
        public static PiiCategoriesExclude HrNationalIdNumber { get; } = new PiiCategoriesExclude(HrNationalIdNumberValue);
        /// <summary> HR Personal Identification Number. </summary>
        public static PiiCategoriesExclude HrPersonalIdentificationNumber { get; } = new PiiCategoriesExclude(HrPersonalIdentificationNumberValue);
        /// <summary> HR Personal Identification OIB Number V2. </summary>
        public static PiiCategoriesExclude HrPersonalIdentificationOIBNumberV2 { get; } = new PiiCategoriesExclude(HrPersonalIdentificationOIBNumberV2Value);
        /// <summary> CY Identity Card. </summary>
        public static PiiCategoriesExclude CyIdentityCard { get; } = new PiiCategoriesExclude(CyIdentityCardValue);
        /// <summary> CY Tax Identification Number. </summary>
        public static PiiCategoriesExclude CyTaxIdentificationNumber { get; } = new PiiCategoriesExclude(CyTaxIdentificationNumberValue);
        /// <summary> CZ Personal Identity Number. </summary>
        public static PiiCategoriesExclude CzPersonalIdentityNumber { get; } = new PiiCategoriesExclude(CzPersonalIdentityNumberValue);
        /// <summary> CZ Personal Identity V2. </summary>
        public static PiiCategoriesExclude CzPersonalIdentityV2 { get; } = new PiiCategoriesExclude(CzPersonalIdentityV2Value);
        /// <summary> DK Personal Identification Number. </summary>
        public static PiiCategoriesExclude DkPersonalIdentificationNumber { get; } = new PiiCategoriesExclude(DkPersonalIdentificationNumberValue);
        /// <summary> DK Personal Identification V2. </summary>
        public static PiiCategoriesExclude DkPersonalIdentificationV2 { get; } = new PiiCategoriesExclude(DkPersonalIdentificationV2Value);
        /// <summary> Drug Enforcement Agency Number. </summary>
        public static PiiCategoriesExclude DrugEnforcementAgencyNumber { get; } = new PiiCategoriesExclude(DrugEnforcementAgencyNumberValue);
        /// <summary> EE Personal Identification Code. </summary>
        public static PiiCategoriesExclude EePersonalIdentificationCode { get; } = new PiiCategoriesExclude(EePersonalIdentificationCodeValue);
        /// <summary> EU Debit Card Number. </summary>
        public static PiiCategoriesExclude EuDebitCardNumber { get; } = new PiiCategoriesExclude(EuDebitCardNumberValue);
        /// <summary> EU Driver's License Number. </summary>
        public static PiiCategoriesExclude EuDriversLicenseNumber { get; } = new PiiCategoriesExclude(EuDriversLicenseNumberValue);
        /// <summary> EU GPS Coordinates. </summary>
        public static PiiCategoriesExclude EuGpsCoordinates { get; } = new PiiCategoriesExclude(EuGpsCoordinatesValue);
        /// <summary> EU National Identification Number. </summary>
        public static PiiCategoriesExclude EuNationalIdentificationNumber { get; } = new PiiCategoriesExclude(EuNationalIdentificationNumberValue);
        /// <summary> EU Passport Number. </summary>
        public static PiiCategoriesExclude EuPassportNumber { get; } = new PiiCategoriesExclude(EuPassportNumberValue);
        /// <summary> EU Social Security Number. </summary>
        public static PiiCategoriesExclude EuSocialSecurityNumber { get; } = new PiiCategoriesExclude(EuSocialSecurityNumberValue);
        /// <summary> EU Tax Identification Number. </summary>
        public static PiiCategoriesExclude EuTaxIdentificationNumber { get; } = new PiiCategoriesExclude(EuTaxIdentificationNumberValue);
        /// <summary> FI European Health Number. </summary>
        public static PiiCategoriesExclude FiEuropeanHealthNumber { get; } = new PiiCategoriesExclude(FiEuropeanHealthNumberValue);
        /// <summary> FI National ID. </summary>
        public static PiiCategoriesExclude FiNationalId { get; } = new PiiCategoriesExclude(FiNationalIdValue);
        /// <summary> FI National ID V2. </summary>
        public static PiiCategoriesExclude FiNationalIdV2 { get; } = new PiiCategoriesExclude(FiNationalIdV2Value);
        /// <summary> FI Passport Number. </summary>
        public static PiiCategoriesExclude FiPassportNumber { get; } = new PiiCategoriesExclude(FiPassportNumberValue);
        /// <summary> FR Driver's License Number. </summary>
        public static PiiCategoriesExclude FrDriversLicenseNumber { get; } = new PiiCategoriesExclude(FrDriversLicenseNumberValue);
        /// <summary> FR Health Insurance Number. </summary>
        public static PiiCategoriesExclude FrHealthInsuranceNumber { get; } = new PiiCategoriesExclude(FrHealthInsuranceNumberValue);
        /// <summary> FR National ID. </summary>
        public static PiiCategoriesExclude FrNationalId { get; } = new PiiCategoriesExclude(FrNationalIdValue);
        /// <summary> FR Passport Number. </summary>
        public static PiiCategoriesExclude FrPassportNumber { get; } = new PiiCategoriesExclude(FrPassportNumberValue);
        /// <summary> FR Social Security Number. </summary>
        public static PiiCategoriesExclude FrSocialSecurityNumber { get; } = new PiiCategoriesExclude(FrSocialSecurityNumberValue);
        /// <summary> FR Tax Identification Number. </summary>
        public static PiiCategoriesExclude FrTaxIdentificationNumber { get; } = new PiiCategoriesExclude(FrTaxIdentificationNumberValue);
        /// <summary> FR Value Added Tax Number. </summary>
        public static PiiCategoriesExclude FrValueAddedTaxNumber { get; } = new PiiCategoriesExclude(FrValueAddedTaxNumberValue);
        /// <summary> DE Driver's License Number. </summary>
        public static PiiCategoriesExclude DeDriversLicenseNumber { get; } = new PiiCategoriesExclude(DeDriversLicenseNumberValue);
        /// <summary> DE Passport Number. </summary>
        public static PiiCategoriesExclude DePassportNumber { get; } = new PiiCategoriesExclude(DePassportNumberValue);
        /// <summary> DE Identity Card Number. </summary>
        public static PiiCategoriesExclude DeIdentityCardNumber { get; } = new PiiCategoriesExclude(DeIdentityCardNumberValue);
        /// <summary> DE Tax Identification Number. </summary>
        public static PiiCategoriesExclude DeTaxIdentificationNumber { get; } = new PiiCategoriesExclude(DeTaxIdentificationNumberValue);
        /// <summary> DE Value Added Number. </summary>
        public static PiiCategoriesExclude DeValueAddedNumber { get; } = new PiiCategoriesExclude(DeValueAddedNumberValue);
        /// <summary> GR National ID Card. </summary>
        public static PiiCategoriesExclude GrNationalIdCard { get; } = new PiiCategoriesExclude(GrNationalIdCardValue);
        /// <summary> GR National ID V2. </summary>
        public static PiiCategoriesExclude GrNationalIdV2 { get; } = new PiiCategoriesExclude(GrNationalIdV2Value);
        /// <summary> GR Tax Identification Number. </summary>
        public static PiiCategoriesExclude GrTaxIdentificationNumber { get; } = new PiiCategoriesExclude(GrTaxIdentificationNumberValue);
        /// <summary> HK Identity Card Number. </summary>
        public static PiiCategoriesExclude HkIdentityCardNumber { get; } = new PiiCategoriesExclude(HkIdentityCardNumberValue);
        /// <summary> HU Value Added Number. </summary>
        public static PiiCategoriesExclude HuValueAddedNumber { get; } = new PiiCategoriesExclude(HuValueAddedNumberValue);
        /// <summary> HU Personal Identification Number. </summary>
        public static PiiCategoriesExclude HuPersonalIdentificationNumber { get; } = new PiiCategoriesExclude(HuPersonalIdentificationNumberValue);
        /// <summary> HU Tax Identification Number. </summary>
        public static PiiCategoriesExclude HuTaxIdentificationNumber { get; } = new PiiCategoriesExclude(HuTaxIdentificationNumberValue);
        /// <summary> IN Permanent Account. </summary>
        public static PiiCategoriesExclude InPermanentAccount { get; } = new PiiCategoriesExclude(InPermanentAccountValue);
        /// <summary> IN Unique Identification Number. </summary>
        public static PiiCategoriesExclude InUniqueIdentificationNumber { get; } = new PiiCategoriesExclude(InUniqueIdentificationNumberValue);
        /// <summary> ID Identity Card Number. </summary>
        public static PiiCategoriesExclude IdIdentityCardNumber { get; } = new PiiCategoriesExclude(IdIdentityCardNumberValue);
        /// <summary> International Banking Account Number. </summary>
        public static PiiCategoriesExclude InternationalBankingAccountNumber { get; } = new PiiCategoriesExclude(InternationalBankingAccountNumberValue);
        /// <summary> IE Personal Public Service Number. </summary>
        public static PiiCategoriesExclude IePersonalPublicServiceNumber { get; } = new PiiCategoriesExclude(IePersonalPublicServiceNumberValue);
        /// <summary> IE Personal Public Service Number V2. </summary>
        public static PiiCategoriesExclude IePersonalPublicServiceNumberV2 { get; } = new PiiCategoriesExclude(IePersonalPublicServiceNumberV2Value);
        /// <summary> IL Bank Account Number. </summary>
        public static PiiCategoriesExclude IlBankAccountNumber { get; } = new PiiCategoriesExclude(IlBankAccountNumberValue);
        /// <summary> IL National ID. </summary>
        public static PiiCategoriesExclude IlNationalId { get; } = new PiiCategoriesExclude(IlNationalIdValue);
        /// <summary> IT Driver's License Number. </summary>
        public static PiiCategoriesExclude ItDriversLicenseNumber { get; } = new PiiCategoriesExclude(ItDriversLicenseNumberValue);
        /// <summary> IT Fiscal Code. </summary>
        public static PiiCategoriesExclude ItFiscalCode { get; } = new PiiCategoriesExclude(ItFiscalCodeValue);
        /// <summary> IT Value Added Tax Number. </summary>
        public static PiiCategoriesExclude ItValueAddedTaxNumber { get; } = new PiiCategoriesExclude(ItValueAddedTaxNumberValue);
        /// <summary> JP Bank Account Number. </summary>
        public static PiiCategoriesExclude JpBankAccountNumber { get; } = new PiiCategoriesExclude(JpBankAccountNumberValue);
        /// <summary> JP Driver's License Number. </summary>
        public static PiiCategoriesExclude JpDriversLicenseNumber { get; } = new PiiCategoriesExclude(JpDriversLicenseNumberValue);
        /// <summary> JP Passport Number. </summary>
        public static PiiCategoriesExclude JpPassportNumber { get; } = new PiiCategoriesExclude(JpPassportNumberValue);
        /// <summary> JP Resident Registration Number. </summary>
        public static PiiCategoriesExclude JpResidentRegistrationNumber { get; } = new PiiCategoriesExclude(JpResidentRegistrationNumberValue);
        /// <summary> JP Social Insurance Number. </summary>
        public static PiiCategoriesExclude JpSocialInsuranceNumber { get; } = new PiiCategoriesExclude(JpSocialInsuranceNumberValue);
        /// <summary> JP My Number Corporate. </summary>
        public static PiiCategoriesExclude JpMyNumberCorporate { get; } = new PiiCategoriesExclude(JpMyNumberCorporateValue);
        /// <summary> JP My Number Personal. </summary>
        public static PiiCategoriesExclude JpMyNumberPersonal { get; } = new PiiCategoriesExclude(JpMyNumberPersonalValue);
        /// <summary> JP Residence Card Number. </summary>
        public static PiiCategoriesExclude JpResidenceCardNumber { get; } = new PiiCategoriesExclude(JpResidenceCardNumberValue);
        /// <summary> LV Personal Code. </summary>
        public static PiiCategoriesExclude LvPersonalCode { get; } = new PiiCategoriesExclude(LvPersonalCodeValue);
        /// <summary> LT Personal Code. </summary>
        public static PiiCategoriesExclude LtPersonalCode { get; } = new PiiCategoriesExclude(LtPersonalCodeValue);
        /// <summary> LU National Identification Number Natural. </summary>
        public static PiiCategoriesExclude LuNationalIdentificationNumberNatural { get; } = new PiiCategoriesExclude(LuNationalIdentificationNumberNaturalValue);
        /// <summary> LU National Identification Number Non Natural. </summary>
        public static PiiCategoriesExclude LuNationalIdentificationNumberNonNatural { get; } = new PiiCategoriesExclude(LuNationalIdentificationNumberNonNaturalValue);
        /// <summary> MY Identity Card Number. </summary>
        public static PiiCategoriesExclude MyIdentityCardNumber { get; } = new PiiCategoriesExclude(MyIdentityCardNumberValue);
        /// <summary> MT Identity Card Number. </summary>
        public static PiiCategoriesExclude MtIdentityCardNumber { get; } = new PiiCategoriesExclude(MtIdentityCardNumberValue);
        /// <summary> MT Tax ID Number. </summary>
        public static PiiCategoriesExclude MtTaxIdNumber { get; } = new PiiCategoriesExclude(MtTaxIdNumberValue);
        /// <summary> NL Citizens Service Number. </summary>
        public static PiiCategoriesExclude NlCitizensServiceNumber { get; } = new PiiCategoriesExclude(NlCitizensServiceNumberValue);
        /// <summary> NL Citizens Service Number V2. </summary>
        public static PiiCategoriesExclude NlCitizensServiceNumberV2 { get; } = new PiiCategoriesExclude(NlCitizensServiceNumberV2Value);
        /// <summary> NL Tax Identification Number. </summary>
        public static PiiCategoriesExclude NlTaxIdentificationNumber { get; } = new PiiCategoriesExclude(NlTaxIdentificationNumberValue);
        /// <summary> NL Value Added Tax Number. </summary>
        public static PiiCategoriesExclude NlValueAddedTaxNumber { get; } = new PiiCategoriesExclude(NlValueAddedTaxNumberValue);
        /// <summary> NZ Bank Account Number. </summary>
        public static PiiCategoriesExclude NzBankAccountNumber { get; } = new PiiCategoriesExclude(NzBankAccountNumberValue);
        /// <summary> NZ Driver's License Number. </summary>
        public static PiiCategoriesExclude NzDriversLicenseNumber { get; } = new PiiCategoriesExclude(NzDriversLicenseNumberValue);
        /// <summary> NZ Inland Revenue Number. </summary>
        public static PiiCategoriesExclude NzInlandRevenueNumber { get; } = new PiiCategoriesExclude(NzInlandRevenueNumberValue);
        /// <summary> NZ Ministry Of Health Number. </summary>
        public static PiiCategoriesExclude NzMinistryOfHealthNumber { get; } = new PiiCategoriesExclude(NzMinistryOfHealthNumberValue);
        /// <summary> NZ Social Welfare Number. </summary>
        public static PiiCategoriesExclude NzSocialWelfareNumber { get; } = new PiiCategoriesExclude(NzSocialWelfareNumberValue);
        /// <summary> NO Identity Number. </summary>
        public static PiiCategoriesExclude NoIdentityNumber { get; } = new PiiCategoriesExclude(NoIdentityNumberValue);
        /// <summary> PH Unified Multi Purpose ID Number. </summary>
        public static PiiCategoriesExclude PhUnifiedMultiPurposeIdNumber { get; } = new PiiCategoriesExclude(PhUnifiedMultiPurposeIdNumberValue);
        /// <summary> PL Identity Card. </summary>
        public static PiiCategoriesExclude PlIdentityCard { get; } = new PiiCategoriesExclude(PlIdentityCardValue);
        /// <summary> PL National ID. </summary>
        public static PiiCategoriesExclude PlNationalId { get; } = new PiiCategoriesExclude(PlNationalIdValue);
        /// <summary> PL National ID V2. </summary>
        public static PiiCategoriesExclude PlNationalIdV2 { get; } = new PiiCategoriesExclude(PlNationalIdV2Value);
        /// <summary> PL Passport Number. </summary>
        public static PiiCategoriesExclude PlPassportNumber { get; } = new PiiCategoriesExclude(PlPassportNumberValue);
        /// <summary> PL Tax Identification Number. </summary>
        public static PiiCategoriesExclude PlTaxIdentificationNumber { get; } = new PiiCategoriesExclude(PlTaxIdentificationNumberValue);
        /// <summary> PL REGON Number. </summary>
        public static PiiCategoriesExclude PlRegonNumber { get; } = new PiiCategoriesExclude(PlRegonNumberValue);
        /// <summary> PT Citizen Card Number. </summary>
        public static PiiCategoriesExclude PtCitizenCardNumber { get; } = new PiiCategoriesExclude(PtCitizenCardNumberValue);
        /// <summary> PT Citizen Card Number V2. </summary>
        public static PiiCategoriesExclude PtCitizenCardNumberV2 { get; } = new PiiCategoriesExclude(PtCitizenCardNumberV2Value);
        /// <summary> PT Tax Identification Number. </summary>
        public static PiiCategoriesExclude PtTaxIdentificationNumber { get; } = new PiiCategoriesExclude(PtTaxIdentificationNumberValue);
        /// <summary> RO Personal Numerical Code. </summary>
        public static PiiCategoriesExclude RoPersonalNumericalCode { get; } = new PiiCategoriesExclude(RoPersonalNumericalCodeValue);
        /// <summary> RU Passport Number Domestic. </summary>
        public static PiiCategoriesExclude RuPassportNumberDomestic { get; } = new PiiCategoriesExclude(RuPassportNumberDomesticValue);
        /// <summary> RU Passport Number International. </summary>
        public static PiiCategoriesExclude RuPassportNumberInternational { get; } = new PiiCategoriesExclude(RuPassportNumberInternationalValue);
        /// <summary> SA National ID. </summary>
        public static PiiCategoriesExclude SaNationalId { get; } = new PiiCategoriesExclude(SaNationalIdValue);
        /// <summary> SG National Registration Identity Card Number. </summary>
        public static PiiCategoriesExclude SgNationalRegistrationIdentityCardNumber { get; } = new PiiCategoriesExclude(SgNationalRegistrationIdentityCardNumberValue);
        /// <summary> SK Personal Number. </summary>
        public static PiiCategoriesExclude SkPersonalNumber { get; } = new PiiCategoriesExclude(SkPersonalNumberValue);
        /// <summary> SI Tax Identification Number. </summary>
        public static PiiCategoriesExclude SiTaxIdentificationNumber { get; } = new PiiCategoriesExclude(SiTaxIdentificationNumberValue);
        /// <summary> SI Unique Master Citizen Number. </summary>
        public static PiiCategoriesExclude SiUniqueMasterCitizenNumber { get; } = new PiiCategoriesExclude(SiUniqueMasterCitizenNumberValue);
        /// <summary> ZA Identification Number. </summary>
        public static PiiCategoriesExclude ZaIdentificationNumber { get; } = new PiiCategoriesExclude(ZaIdentificationNumberValue);
        /// <summary> KR Resident Registration Number. </summary>
        public static PiiCategoriesExclude KrResidentRegistrationNumber { get; } = new PiiCategoriesExclude(KrResidentRegistrationNumberValue);
        /// <summary> ES DNI. </summary>
        public static PiiCategoriesExclude EsDni { get; } = new PiiCategoriesExclude(EsDniValue);
        /// <summary> ES Social Security Number. </summary>
        public static PiiCategoriesExclude EsSocialSecurityNumber { get; } = new PiiCategoriesExclude(EsSocialSecurityNumberValue);
        /// <summary> ES Tax Identification Number. </summary>
        public static PiiCategoriesExclude EsTaxIdentificationNumber { get; } = new PiiCategoriesExclude(EsTaxIdentificationNumberValue);
        /// <summary> SQL Server Connection String. </summary>
        public static PiiCategoriesExclude SqlServerConnectionString { get; } = new PiiCategoriesExclude(SqlServerConnectionStringValue);
        /// <summary> SE National ID. </summary>
        public static PiiCategoriesExclude SeNationalId { get; } = new PiiCategoriesExclude(SeNationalIdValue);
        /// <summary> SE National ID V2. </summary>
        public static PiiCategoriesExclude SeNationalIdV2 { get; } = new PiiCategoriesExclude(SeNationalIdV2Value);
        /// <summary> SE Passport Number. </summary>
        public static PiiCategoriesExclude SePassportNumber { get; } = new PiiCategoriesExclude(SePassportNumberValue);
        /// <summary> SE Tax Identification Number. </summary>
        public static PiiCategoriesExclude SeTaxIdentificationNumber { get; } = new PiiCategoriesExclude(SeTaxIdentificationNumberValue);
        /// <summary> SWIFT Code. </summary>
        public static PiiCategoriesExclude SwiftCode { get; } = new PiiCategoriesExclude(SwiftCodeValue);
        /// <summary> CH Social Security Number. </summary>
        public static PiiCategoriesExclude ChSocialSecurityNumber { get; } = new PiiCategoriesExclude(ChSocialSecurityNumberValue);
        /// <summary> TW National ID. </summary>
        public static PiiCategoriesExclude TwNationalId { get; } = new PiiCategoriesExclude(TwNationalIdValue);
        /// <summary> TW Passport Number. </summary>
        public static PiiCategoriesExclude TwPassportNumber { get; } = new PiiCategoriesExclude(TwPassportNumberValue);
        /// <summary> TW Resident Certificate. </summary>
        public static PiiCategoriesExclude TwResidentCertificate { get; } = new PiiCategoriesExclude(TwResidentCertificateValue);
        /// <summary> TH Population Identification Code. </summary>
        public static PiiCategoriesExclude ThPopulationIdentificationCode { get; } = new PiiCategoriesExclude(ThPopulationIdentificationCodeValue);
        /// <summary> TR National Identification Number. </summary>
        public static PiiCategoriesExclude TrNationalIdentificationNumber { get; } = new PiiCategoriesExclude(TrNationalIdentificationNumberValue);
        /// <summary> UK Driver's License Number. </summary>
        public static PiiCategoriesExclude UkDriversLicenseNumber { get; } = new PiiCategoriesExclude(UkDriversLicenseNumberValue);
        /// <summary> UK Electoral Roll Number. </summary>
        public static PiiCategoriesExclude UkElectoralRollNumber { get; } = new PiiCategoriesExclude(UkElectoralRollNumberValue);
        /// <summary> UK National Health Number. </summary>
        public static PiiCategoriesExclude UkNationalHealthNumber { get; } = new PiiCategoriesExclude(UkNationalHealthNumberValue);
        /// <summary> UK National Insurance Number. </summary>
        public static PiiCategoriesExclude UkNationalInsuranceNumber { get; } = new PiiCategoriesExclude(UkNationalInsuranceNumberValue);
        /// <summary> UK Unique Taxpayer Number. </summary>
        public static PiiCategoriesExclude UkUniqueTaxpayerNumber { get; } = new PiiCategoriesExclude(UkUniqueTaxpayerNumberValue);
        /// <summary> US UK Passport Number. </summary>
        public static PiiCategoriesExclude UsUkPassportNumber { get; } = new PiiCategoriesExclude(UsUkPassportNumberValue);
        /// <summary> US Bank Account Number. </summary>
        public static PiiCategoriesExclude UsBankAccountNumber { get; } = new PiiCategoriesExclude(UsBankAccountNumberValue);
        /// <summary> US Driver's License Number. </summary>
        public static PiiCategoriesExclude UsDriversLicenseNumber { get; } = new PiiCategoriesExclude(UsDriversLicenseNumberValue);
        /// <summary> US Individual Taxpayer Identification. </summary>
        public static PiiCategoriesExclude UsIndividualTaxpayerIdentification { get; } = new PiiCategoriesExclude(UsIndividualTaxpayerIdentificationValue);
        /// <summary> US Social Security Number. </summary>
        public static PiiCategoriesExclude UsSocialSecurityNumber { get; } = new PiiCategoriesExclude(UsSocialSecurityNumberValue);
        /// <summary> UA Passport Number Domestic. </summary>
        public static PiiCategoriesExclude UaPassportNumberDomestic { get; } = new PiiCategoriesExclude(UaPassportNumberDomesticValue);
        /// <summary> UA Passport Number International. </summary>
        public static PiiCategoriesExclude UaPassportNumberInternational { get; } = new PiiCategoriesExclude(UaPassportNumberInternationalValue);
        /// <summary> Organization. </summary>
        public static PiiCategoriesExclude Organization { get; } = new PiiCategoriesExclude(OrganizationValue);
        /// <summary> Email. </summary>
        public static PiiCategoriesExclude Email { get; } = new PiiCategoriesExclude(EmailValue);
        /// <summary> URL. </summary>
        public static PiiCategoriesExclude URL { get; } = new PiiCategoriesExclude(URLValue);
        /// <summary> Age. </summary>
        public static PiiCategoriesExclude Age { get; } = new PiiCategoriesExclude(AgeValue);
        /// <summary> Phone Number. </summary>
        public static PiiCategoriesExclude PhoneNumber { get; } = new PiiCategoriesExclude(PhoneNumberValue);
        /// <summary> IP Address. </summary>
        public static PiiCategoriesExclude IPAddress { get; } = new PiiCategoriesExclude(IPAddressValue);
        /// <summary> Date. </summary>
        public static PiiCategoriesExclude Date { get; } = new PiiCategoriesExclude(DateValue);
        /// <summary> Person. </summary>
        public static PiiCategoriesExclude Person { get; } = new PiiCategoriesExclude(PersonValue);
        /// <summary> Address. </summary>
        public static PiiCategoriesExclude Address { get; } = new PiiCategoriesExclude(AddressValue);
        /// <summary> Determines if two <see cref="PiiCategoriesExclude"/> values are the same. </summary>
        public static bool operator ==(PiiCategoriesExclude left, PiiCategoriesExclude right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PiiCategoriesExclude"/> values are not the same. </summary>
        public static bool operator !=(PiiCategoriesExclude left, PiiCategoriesExclude right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PiiCategoriesExclude"/>. </summary>
        public static implicit operator PiiCategoriesExclude(string value) => new PiiCategoriesExclude(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PiiCategoriesExclude other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PiiCategoriesExclude other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
