// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Supported parameters for a PII Entities Recognition task. </summary>
    public partial class PiiActionContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PiiActionContent"/>. </summary>
        public PiiActionContent()
        {
            PiiCategories = new ChangeTrackingList<PiiCategory>();
            ExcludePiiCategories = new ChangeTrackingList<PiiCategoriesExclude>();
        }

        /// <summary> Initializes a new instance of <see cref="PiiActionContent"/>. </summary>
        /// <param name="loggingOptOut"> logging opt out. </param>
        /// <param name="modelVersion"> model version. </param>
        /// <param name="domain"> Domain for PII task. </param>
        /// <param name="piiCategories"> Enumeration of PII categories to be returned in the response. </param>
        /// <param name="stringIndexType"> StringIndexType to be used for analysis. </param>
        /// <param name="excludePiiCategories"> Enumeration of PII categories to be excluded in the response. </param>
        /// <param name="redactionCharacter"> Character to be used for redaction. Default in '*'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PiiActionContent(bool? loggingOptOut, string modelVersion, PiiDomain? domain, IList<PiiCategory> piiCategories, StringIndexType? stringIndexType, IList<PiiCategoriesExclude> excludePiiCategories, RedactionCharacter? redactionCharacter, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LoggingOptOut = loggingOptOut;
            ModelVersion = modelVersion;
            Domain = domain;
            PiiCategories = piiCategories;
            StringIndexType = stringIndexType;
            ExcludePiiCategories = excludePiiCategories;
            RedactionCharacter = redactionCharacter;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> logging opt out. </summary>
        public bool? LoggingOptOut { get; set; }
        /// <summary> model version. </summary>
        public string ModelVersion { get; set; }
        /// <summary> Domain for PII task. </summary>
        public PiiDomain? Domain { get; set; }
        /// <summary> Enumeration of PII categories to be returned in the response. </summary>
        public IList<PiiCategory> PiiCategories { get; }
        /// <summary> StringIndexType to be used for analysis. </summary>
        public StringIndexType? StringIndexType { get; set; }
        /// <summary> Enumeration of PII categories to be excluded in the response. </summary>
        public IList<PiiCategoriesExclude> ExcludePiiCategories { get; }
        /// <summary> Character to be used for redaction. Default in '*'. </summary>
        public RedactionCharacter? RedactionCharacter { get; set; }
    }
}
