// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> A metadata for numeric entity instances. </summary>
    public partial class OrdinalMetadata : BaseMetadata
    {
        /// <summary> Initializes a new instance of <see cref="OrdinalMetadata"/>. </summary>
        /// <param name="offset"> The offset with respect to the reference (e.g., offset = -1 indicates the second to last). </param>
        /// <param name="relativeTo"> The reference point that the ordinal number denotes. </param>
        /// <param name="value"> A simple arithmetic expression that the ordinal denotes. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="offset"/> or <paramref name="value"/> is null. </exception>
        internal OrdinalMetadata(string offset, RelativeTo relativeTo, string value)
        {
            Argument.AssertNotNull(offset, nameof(offset));
            Argument.AssertNotNull(value, nameof(value));

            MetadataKind = MetadataKind.OrdinalMetadata;
            Offset = offset;
            RelativeTo = relativeTo;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="OrdinalMetadata"/>. </summary>
        /// <param name="metadataKind"> The entity Metadata object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="offset"> The offset with respect to the reference (e.g., offset = -1 indicates the second to last). </param>
        /// <param name="relativeTo"> The reference point that the ordinal number denotes. </param>
        /// <param name="value"> A simple arithmetic expression that the ordinal denotes. </param>
        internal OrdinalMetadata(MetadataKind metadataKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string offset, RelativeTo relativeTo, string value) : base(metadataKind, serializedAdditionalRawData)
        {
            Offset = offset;
            RelativeTo = relativeTo;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="OrdinalMetadata"/> for deserialization. </summary>
        internal OrdinalMetadata()
        {
        }

        /// <summary> The offset with respect to the reference (e.g., offset = -1 indicates the second to last). </summary>
        public string Offset { get; }
        /// <summary> The reference point that the ordinal number denotes. </summary>
        public RelativeTo RelativeTo { get; }
        /// <summary> A simple arithmetic expression that the ordinal denotes. </summary>
        public string Value { get; }
    }
}
