// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> represents the Metadata of numeric intervals. </summary>
    public partial class NumericRangeMetadata : BaseMetadata
    {
        /// <summary> Initializes a new instance of <see cref="NumericRangeMetadata"/>. </summary>
        /// <param name="rangeKind"> Kind of numeric ranges supported - like Number, Speed, etc. </param>
        /// <param name="minimum"> The beginning value of  the interval. </param>
        /// <param name="maximum"> The ending value of the interval. </param>
        internal NumericRangeMetadata(RangeKind rangeKind, double minimum, double maximum)
        {
            MetadataKind = MetadataKind.NumericRangeMetadata;
            RangeKind = rangeKind;
            Minimum = minimum;
            Maximum = maximum;
        }

        /// <summary> Initializes a new instance of <see cref="NumericRangeMetadata"/>. </summary>
        /// <param name="metadataKind"> The entity Metadata object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="rangeKind"> Kind of numeric ranges supported - like Number, Speed, etc. </param>
        /// <param name="minimum"> The beginning value of  the interval. </param>
        /// <param name="maximum"> The ending value of the interval. </param>
        /// <param name="rangeInclusivity"> The inclusiveness of this range. </param>
        internal NumericRangeMetadata(MetadataKind metadataKind, IDictionary<string, BinaryData> serializedAdditionalRawData, RangeKind rangeKind, double minimum, double maximum, RangeInclusivity? rangeInclusivity) : base(metadataKind, serializedAdditionalRawData)
        {
            RangeKind = rangeKind;
            Minimum = minimum;
            Maximum = maximum;
            RangeInclusivity = rangeInclusivity;
        }

        /// <summary> Initializes a new instance of <see cref="NumericRangeMetadata"/> for deserialization. </summary>
        internal NumericRangeMetadata()
        {
        }

        /// <summary> Kind of numeric ranges supported - like Number, Speed, etc. </summary>
        public RangeKind RangeKind { get; }
        /// <summary> The beginning value of  the interval. </summary>
        public double Minimum { get; }
        /// <summary> The ending value of the interval. </summary>
        public double Maximum { get; }
        /// <summary> The inclusiveness of this range. </summary>
        public RangeInclusivity? RangeInclusivity { get; }
    }
}
