// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> A metadata for numeric entity instances. </summary>
    public partial class NumberMetadata : BaseMetadata
    {
        /// <summary> Initializes a new instance of <see cref="NumberMetadata"/>. </summary>
        /// <param name="numberKind"> Kind of the number type. </param>
        /// <param name="value"> A numeric representation of what the extracted text denotes. </param>
        internal NumberMetadata(NumberKind numberKind, double value)
        {
            MetadataKind = MetadataKind.NumberMetadata;
            NumberKind = numberKind;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="NumberMetadata"/>. </summary>
        /// <param name="metadataKind"> The entity Metadata object kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="numberKind"> Kind of the number type. </param>
        /// <param name="value"> A numeric representation of what the extracted text denotes. </param>
        internal NumberMetadata(MetadataKind metadataKind, IDictionary<string, BinaryData> serializedAdditionalRawData, NumberKind numberKind, double value) : base(metadataKind, serializedAdditionalRawData)
        {
            NumberKind = numberKind;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="NumberMetadata"/> for deserialization. </summary>
        internal NumberMetadata()
        {
        }

        /// <summary> Kind of the number type. </summary>
        public NumberKind NumberKind { get; }
        /// <summary> A numeric representation of what the extracted text denotes. </summary>
        public double Value { get; }
    }
}
