// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> The entity Metadata object kind. </summary>
    internal readonly partial struct MetadataKind : IEquatable<MetadataKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetadataKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetadataKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DateMetadataValue = "DateMetadata";
        private const string DateTimeMetadataValue = "DateTimeMetadata";
        private const string TimeMetadataValue = "TimeMetadata";
        private const string TemporalSetMetadataValue = "TemporalSetMetadata";
        private const string NumberMetadataValue = "NumberMetadata";
        private const string OrdinalMetadataValue = "OrdinalMetadata";
        private const string SpeedMetadataValue = "SpeedMetadata";
        private const string WeightMetadataValue = "WeightMetadata";
        private const string LengthMetadataValue = "LengthMetadata";
        private const string VolumeMetadataValue = "VolumeMetadata";
        private const string AreaMetadataValue = "AreaMetadata";
        private const string AgeMetadataValue = "AgeMetadata";
        private const string InformationMetadataValue = "InformationMetadata";
        private const string TemperatureMetadataValue = "TemperatureMetadata";
        private const string CurrencyMetadataValue = "CurrencyMetadata";
        private const string NumericRangeMetadataValue = "NumericRangeMetadata";
        private const string TemporalSpanMetadataValue = "TemporalSpanMetadata";

        /// <summary> Metadata for date-related values. </summary>
        public static MetadataKind DateMetadata { get; } = new MetadataKind(DateMetadataValue);
        /// <summary> Metadata for date and time-related values. </summary>
        public static MetadataKind DateTimeMetadata { get; } = new MetadataKind(DateTimeMetadataValue);
        /// <summary> Metadata for time-related values. </summary>
        public static MetadataKind TimeMetadata { get; } = new MetadataKind(TimeMetadataValue);
        /// <summary> Metadata for set of time-related values. </summary>
        public static MetadataKind TemporalSetMetadata { get; } = new MetadataKind(TemporalSetMetadataValue);
        /// <summary> Metadata for numeric values. </summary>
        public static MetadataKind NumberMetadata { get; } = new MetadataKind(NumberMetadataValue);
        /// <summary> Metadata for ordinal numbers. </summary>
        public static MetadataKind OrdinalMetadata { get; } = new MetadataKind(OrdinalMetadataValue);
        /// <summary> Metadata for speed-related values. </summary>
        public static MetadataKind SpeedMetadata { get; } = new MetadataKind(SpeedMetadataValue);
        /// <summary> Metadata for weight-related values. </summary>
        public static MetadataKind WeightMetadata { get; } = new MetadataKind(WeightMetadataValue);
        /// <summary> Metadata for length-related values. </summary>
        public static MetadataKind LengthMetadata { get; } = new MetadataKind(LengthMetadataValue);
        /// <summary> Metadata for volume-related values. </summary>
        public static MetadataKind VolumeMetadata { get; } = new MetadataKind(VolumeMetadataValue);
        /// <summary> Metadata for area-related values. </summary>
        public static MetadataKind AreaMetadata { get; } = new MetadataKind(AreaMetadataValue);
        /// <summary> Metadata for age-related values. </summary>
        public static MetadataKind AgeMetadata { get; } = new MetadataKind(AgeMetadataValue);
        /// <summary> Metadata for information-related values. </summary>
        public static MetadataKind InformationMetadata { get; } = new MetadataKind(InformationMetadataValue);
        /// <summary> Metadata for temperature-related values. </summary>
        public static MetadataKind TemperatureMetadata { get; } = new MetadataKind(TemperatureMetadataValue);
        /// <summary> Metadata for currency-related values. </summary>
        public static MetadataKind CurrencyMetadata { get; } = new MetadataKind(CurrencyMetadataValue);
        /// <summary> Metadata for numeric range values. </summary>
        public static MetadataKind NumericRangeMetadata { get; } = new MetadataKind(NumericRangeMetadataValue);
        /// <summary> Metadata for temporal span values. </summary>
        public static MetadataKind TemporalSpanMetadata { get; } = new MetadataKind(TemporalSpanMetadataValue);
        /// <summary> Determines if two <see cref="MetadataKind"/> values are the same. </summary>
        public static bool operator ==(MetadataKind left, MetadataKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetadataKind"/> values are not the same. </summary>
        public static bool operator !=(MetadataKind left, MetadataKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetadataKind"/>. </summary>
        public static implicit operator MetadataKind(string value) => new MetadataKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetadataKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetadataKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
