// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> This object contains information of the list component of the detected entity. </summary>
    public partial class ListComponent : EntityComponentInformation
    {
        /// <summary> Initializes a new instance of <see cref="ListComponent"/>. </summary>
        internal ListComponent()
        {
            EntityComponentKind = EntityComponentKind.ListComponent;
        }

        /// <summary> Initializes a new instance of <see cref="ListComponent"/>. </summary>
        /// <param name="entityComponentKind"> Kind of entity component. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The list key of an extracted entity type. </param>
        internal ListComponent(EntityComponentKind entityComponentKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string value) : base(entityComponentKind, serializedAdditionalRawData)
        {
            Value = value;
        }

        /// <summary> The list key of an extracted entity type. </summary>
        public string Value { get; }
    }
}
