// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> This object contains information of the learned component of the detected entity. </summary>
    public partial class LearnedComponent : EntityComponentInformation
    {
        /// <summary> Initializes a new instance of <see cref="LearnedComponent"/>. </summary>
        internal LearnedComponent()
        {
            EntityComponentKind = EntityComponentKind.LearnedComponent;
        }

        /// <summary> Initializes a new instance of <see cref="LearnedComponent"/>. </summary>
        /// <param name="entityComponentKind"> Kind of entity component. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The learned component of an extracted entity type. </param>
        internal LearnedComponent(EntityComponentKind entityComponentKind, IDictionary<string, BinaryData> serializedAdditionalRawData, string value) : base(entityComponentKind, serializedAdditionalRawData)
        {
            Value = value;
        }

        /// <summary> The learned component of an extracted entity type. </summary>
        public string Value { get; }
    }
}
