// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> An object representing the task definition for a Key Phrase Extraction task. </summary>
    public partial class KeyPhraseOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="KeyPhraseOperationAction"/>. </summary>
        public KeyPhraseOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.KeyPhraseExtraction;
        }

        /// <summary> Initializes a new instance of <see cref="KeyPhraseOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Key phrase extraction task parameters. </param>
        internal KeyPhraseOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, KeyPhraseActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Key phrase extraction task parameters. </summary>
        public KeyPhraseActionContent ActionContent { get; set; }
    }
}
