// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> Contains the analyze text KeyPhraseExtraction LRO task. </summary>
    public partial class KeyPhraseExtractionOperationResult : AnalyzeTextOperationResult
    {
        /// <summary> Initializes a new instance of <see cref="KeyPhraseExtractionOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="results"> The list of Key phrase extraction results. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="results"/> is null. </exception>
        internal KeyPhraseExtractionOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, KeyPhraseResult results) : base(lastUpdateDateTime, status)
        {
            Argument.AssertNotNull(results, nameof(results));

            Kind = AnalyzeTextOperationResultsKind.KeyPhraseExtractionOperationResults;
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="KeyPhraseExtractionOperationResult"/>. </summary>
        /// <param name="lastUpdateDateTime"> The last updated time in UTC for the task. </param>
        /// <param name="status"> The status of the task at the mentioned last update time. </param>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> Kind of the task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="results"> The list of Key phrase extraction results. </param>
        internal KeyPhraseExtractionOperationResult(DateTimeOffset lastUpdateDateTime, TextActionState status, string name, AnalyzeTextOperationResultsKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, KeyPhraseResult results) : base(lastUpdateDateTime, status, name, kind, serializedAdditionalRawData)
        {
            Results = results;
        }

        /// <summary> Initializes a new instance of <see cref="KeyPhraseExtractionOperationResult"/> for deserialization. </summary>
        internal KeyPhraseExtractionOperationResult()
        {
        }

        /// <summary> The list of Key phrase extraction results. </summary>
        public KeyPhraseResult Results { get; }
    }
}
