// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.Language.Text
{
    /// <summary> The long running task to be performed by the service on the Healthcare input documents. </summary>
    public partial class HealthcareOperationAction : AnalyzeTextOperationAction
    {
        /// <summary> Initializes a new instance of <see cref="HealthcareOperationAction"/>. </summary>
        public HealthcareOperationAction()
        {
            Kind = AnalyzeTextOperationActionKind.Healthcare;
        }

        /// <summary> Initializes a new instance of <see cref="HealthcareOperationAction"/>. </summary>
        /// <param name="name"> task name. </param>
        /// <param name="kind"> The kind of task to perform. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionContent"> Parameters for the Healthcare task. </param>
        internal HealthcareOperationAction(string name, AnalyzeTextOperationActionKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, HealthcareActionContent actionContent) : base(name, kind, serializedAdditionalRawData)
        {
            ActionContent = actionContent;
        }

        /// <summary> Parameters for the Healthcare task. </summary>
        public HealthcareActionContent ActionContent { get; set; }
    }
}
