// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.Language.Text
{
    /// <summary> Document type. </summary>
    public readonly partial struct HealthcareDocumentType : IEquatable<HealthcareDocumentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthcareDocumentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthcareDocumentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ClinicalTrialValue = "ClinicalTrial";
        private const string DischargeSummaryValue = "DischargeSummary";
        private const string ProgressNoteValue = "ProgressNote";
        private const string HistoryAndPhysicalValue = "HistoryAndPhysical";
        private const string ConsultValue = "Consult";
        private const string ImagingValue = "Imaging";
        private const string PathologyValue = "Pathology";
        private const string ProcedureNoteValue = "ProcedureNote";

        /// <summary> None document type. </summary>
        public static HealthcareDocumentType None { get; } = new HealthcareDocumentType(NoneValue);
        /// <summary> Clinical trial document type. </summary>
        public static HealthcareDocumentType ClinicalTrial { get; } = new HealthcareDocumentType(ClinicalTrialValue);
        /// <summary> Discharge summary document type. </summary>
        public static HealthcareDocumentType DischargeSummary { get; } = new HealthcareDocumentType(DischargeSummaryValue);
        /// <summary> Progress note document type. </summary>
        public static HealthcareDocumentType ProgressNote { get; } = new HealthcareDocumentType(ProgressNoteValue);
        /// <summary> History and physical document type. </summary>
        public static HealthcareDocumentType HistoryAndPhysical { get; } = new HealthcareDocumentType(HistoryAndPhysicalValue);
        /// <summary> Consult document type. </summary>
        public static HealthcareDocumentType Consult { get; } = new HealthcareDocumentType(ConsultValue);
        /// <summary> Imaging document type. </summary>
        public static HealthcareDocumentType Imaging { get; } = new HealthcareDocumentType(ImagingValue);
        /// <summary> Pathology document type. </summary>
        public static HealthcareDocumentType Pathology { get; } = new HealthcareDocumentType(PathologyValue);
        /// <summary> Procedure note document type. </summary>
        public static HealthcareDocumentType ProcedureNote { get; } = new HealthcareDocumentType(ProcedureNoteValue);
        /// <summary> Determines if two <see cref="HealthcareDocumentType"/> values are the same. </summary>
        public static bool operator ==(HealthcareDocumentType left, HealthcareDocumentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthcareDocumentType"/> values are not the same. </summary>
        public static bool operator !=(HealthcareDocumentType left, HealthcareDocumentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthcareDocumentType"/>. </summary>
        public static implicit operator HealthcareDocumentType(string value) => new HealthcareDocumentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthcareDocumentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthcareDocumentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
