// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.Text
{
    internal static partial class HealthcareAssertionTemporalityExtensions
    {
        public static string ToSerialString(this HealthcareAssertionTemporality value) => value switch
        {
            HealthcareAssertionTemporality.Current => "current",
            HealthcareAssertionTemporality.Past => "past",
            HealthcareAssertionTemporality.Future => "future",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionTemporality value.")
        };

        public static HealthcareAssertionTemporality ToHealthcareAssertionTemporality(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "current")) return HealthcareAssertionTemporality.Current;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "past")) return HealthcareAssertionTemporality.Past;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "future")) return HealthcareAssertionTemporality.Future;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionTemporality value.");
        }
    }
}
