// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.Text
{
    internal static partial class HealthcareAssertionConditionalityExtensions
    {
        public static string ToSerialString(this HealthcareAssertionConditionality value) => value switch
        {
            HealthcareAssertionConditionality.Hypothetical => "hypothetical",
            HealthcareAssertionConditionality.Conditional => "conditional",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionConditionality value.")
        };

        public static HealthcareAssertionConditionality ToHealthcareAssertionConditionality(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "hypothetical")) return HealthcareAssertionConditionality.Hypothetical;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "conditional")) return HealthcareAssertionConditionality.Conditional;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionConditionality value.");
        }
    }
}
