// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.AI.Language.Text
{
    internal static partial class HealthcareAssertionCertaintyExtensions
    {
        public static string ToSerialString(this HealthcareAssertionCertainty value) => value switch
        {
            HealthcareAssertionCertainty.Positive => "positive",
            HealthcareAssertionCertainty.PositivePossible => "positivePossible",
            HealthcareAssertionCertainty.NeutralPossible => "neutralPossible",
            HealthcareAssertionCertainty.NegativePossible => "negativePossible",
            HealthcareAssertionCertainty.Negative => "negative",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionCertainty value.")
        };

        public static HealthcareAssertionCertainty ToHealthcareAssertionCertainty(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positive")) return HealthcareAssertionCertainty.Positive;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "positivePossible")) return HealthcareAssertionCertainty.PositivePossible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "neutralPossible")) return HealthcareAssertionCertainty.NeutralPossible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negativePossible")) return HealthcareAssertionCertainty.NegativePossible;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "negative")) return HealthcareAssertionCertainty.Negative;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown HealthcareAssertionCertainty value.");
        }
    }
}
